/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import ai.vespa.searchlib.searchprotocol.protobuf.SearchProtocol;
import com.yahoo.compress.IntegerCompressor;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.SimpleTaggableItem;
import com.yahoo.prelude.query.ToProtobuf;
import com.yahoo.prelude.query.textualrepresentation.Discloser;
import java.nio.ByteBuffer;
import java.util.Objects;

public class NearestNeighborItem
extends SimpleTaggableItem {
    private int targetNumHits = 0;
    private int hnswExploreAdditionalHits = 0;
    private double distanceThreshold = Double.POSITIVE_INFINITY;
    private boolean approximate = true;
    private String field;
    private final String queryTensorName;

    public NearestNeighborItem(String fieldName, String queryTensorName) {
        this.field = fieldName;
        this.queryTensorName = queryTensorName;
    }

    public int getTargetNumHits() {
        return this.targetNumHits;
    }

    public String getIndexName() {
        return this.field;
    }

    public double getDistanceThreshold() {
        return this.distanceThreshold;
    }

    public int getHnswExploreAdditionalHits() {
        return this.hnswExploreAdditionalHits;
    }

    public boolean getAllowApproximate() {
        return this.approximate;
    }

    public String getQueryTensorName() {
        return this.queryTensorName;
    }

    public void setTargetNumHits(int target) {
        this.targetNumHits = target;
    }

    public void setDistanceThreshold(double threshold) {
        this.distanceThreshold = threshold;
    }

    public void setHnswExploreAdditionalHits(int num) {
        this.hnswExploreAdditionalHits = num;
    }

    public void setAllowApproximate(boolean value) {
        this.approximate = value;
    }

    @Override
    public void setIndexName(String index) {
        this.field = index;
    }

    @Override
    public Item.ItemType getItemType() {
        return Item.ItemType.NEAREST_NEIGHBOR;
    }

    @Override
    public String getName() {
        return "NEAREST_NEIGHBOR";
    }

    @Override
    public int getTermCount() {
        return 1;
    }

    @Override
    public int encode(ByteBuffer buffer) {
        super.encodeThis(buffer);
        NearestNeighborItem.putString(this.field, buffer);
        NearestNeighborItem.putString(this.queryTensorName, buffer);
        int approxNum = this.approximate ? 1 : 0;
        IntegerCompressor.putCompressedPositiveNumber((int)this.targetNumHits, (ByteBuffer)buffer);
        IntegerCompressor.putCompressedPositiveNumber((int)approxNum, (ByteBuffer)buffer);
        IntegerCompressor.putCompressedPositiveNumber((int)this.hnswExploreAdditionalHits, (ByteBuffer)buffer);
        buffer.putDouble(this.distanceThreshold);
        return 1;
    }

    @Override
    protected void appendBodyString(StringBuilder buffer) {
        buffer.append("{field=").append(this.field);
        buffer.append(",queryTensorName=").append(this.queryTensorName);
        buffer.append(",hnsw.exploreAdditionalHits=").append(this.hnswExploreAdditionalHits);
        buffer.append(",distanceThreshold=").append(this.distanceThreshold);
        buffer.append(",approximate=").append(this.approximate);
        buffer.append(",targetHits=").append(this.targetNumHits).append("}");
    }

    @Override
    public void disclose(Discloser discloser) {
        super.disclose(discloser);
        discloser.addProperty("field", this.field);
        discloser.addProperty("queryTensorName", this.queryTensorName);
        discloser.addProperty("hnsw.exploreAdditionalHits", this.hnswExploreAdditionalHits);
        discloser.addProperty("distanceThreshold", this.distanceThreshold);
        discloser.addProperty("approximate", this.approximate);
        discloser.addProperty("targetHits", this.targetNumHits);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        NearestNeighborItem other = (NearestNeighborItem)o;
        if (this.targetNumHits != other.targetNumHits) {
            return false;
        }
        if (this.hnswExploreAdditionalHits != other.hnswExploreAdditionalHits) {
            return false;
        }
        if (this.distanceThreshold != other.distanceThreshold) {
            return false;
        }
        if (this.approximate != other.approximate) {
            return false;
        }
        if (!this.field.equals(other.field)) {
            return false;
        }
        return this.queryTensorName.equals(other.queryTensorName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.targetNumHits, this.hnswExploreAdditionalHits, this.distanceThreshold, this.approximate, this.field, this.queryTensorName);
    }

    @Override
    SearchProtocol.QueryTreeItem toProtobuf() {
        SearchProtocol.ItemNearestNeighbor.Builder builder = SearchProtocol.ItemNearestNeighbor.newBuilder();
        builder.setProperties(ToProtobuf.buildTermProperties(this, this.getIndexName()));
        builder.setQueryTensorName(this.queryTensorName);
        builder.setTargetNumHits(this.targetNumHits);
        builder.setAllowApproximate(this.approximate);
        builder.setExploreAdditionalHits(this.hnswExploreAdditionalHits);
        builder.setDistanceThreshold(this.distanceThreshold);
        return SearchProtocol.QueryTreeItem.newBuilder().setItemNearestNeighbor(builder.build()).build();
    }
}

