/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.logging;

import com.yahoo.component.AbstractComponent;
import com.yahoo.search.logging.Logger;
import com.yahoo.search.logging.LoggerEntry;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

abstract class AbstractThreadedLogger
extends AbstractComponent
implements Logger {
    private static final java.util.logging.Logger log = java.util.logging.Logger.getLogger(AbstractThreadedLogger.class.getName());
    static final int DEFAULT_MAX_THREADS = 1;
    static final int DEFAULT_QUEUE_SIZE = 1000;
    protected final WorkerThreadExecutor executor;

    AbstractThreadedLogger() {
        this(1, 1000);
    }

    AbstractThreadedLogger(int threads, int queueSize) {
        this.executor = new WorkerThreadExecutor(threads, queueSize);
    }

    AbstractThreadedLogger(int threads, int queueSize, ThreadFactory factory) {
        this.executor = new WorkerThreadExecutor(threads, queueSize, factory);
    }

    @Override
    public boolean send(LoggerEntry entry) {
        return this.enqueue(entry);
    }

    protected boolean enqueue(LoggerEntry entry) {
        try {
            this.executor.execute(() -> this.dequeue(entry));
        }
        catch (RejectedExecutionException e) {
            return false;
        }
        return true;
    }

    protected void dequeue(LoggerEntry entry) {
        this.transport(entry);
    }

    public abstract boolean transport(LoggerEntry var1);

    public void deconstruct() {
        this.executor.close();
    }

    protected static class WorkerThreadExecutor
    implements Executor {
        protected final ThreadPoolExecutor executor;

        WorkerThreadExecutor(int threads, int queueSize) {
            this(threads, queueSize, WorkerThread::new);
        }

        WorkerThreadExecutor(int threads, int queueSize, ThreadFactory threadFactory) {
            this.executor = new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueSize), threadFactory);
        }

        public void close() {
            try {
                this.executor.shutdown();
                this.executor.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.executor.shutdownNow();
            }
        }

        @Override
        public void execute(Runnable r) {
            this.executor.execute(r);
        }
    }

    private static class WorkerThread
    extends Thread {
        public WorkerThread(Runnable r) {
            super(r);
        }

        @Override
        public void run() {
            try {
                super.run();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, String.format("Error while sending logger entry: %s", e), e);
            }
        }
    }
}

