/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.semantics.rule;

import com.yahoo.prelude.semantics.engine.RuleEvaluation;
import com.yahoo.prelude.semantics.rule.Condition;

public class NamedCondition {
    private String conditionName;
    private Condition condition;

    public NamedCondition(String name, Condition condition) {
        this.conditionName = name;
        this.condition = condition;
    }

    public String getName() {
        return this.conditionName;
    }

    public void setName(String name) {
        this.conditionName = name;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public boolean matches(RuleEvaluation e) {
        if (e.getTraceLevel() >= 3) {
            e.trace(3, "Evaluating '" + String.valueOf(this) + "' at " + String.valueOf(e.currentItem()));
            e.indentTrace();
        }
        boolean matches = this.condition.matches(e);
        if (e.getTraceLevel() >= 3) {
            e.unindentTrace();
            if (matches) {
                e.trace(3, "Matched '" + String.valueOf(this) + "' at " + String.valueOf(e.previousItem()));
            } else if (e.getTraceLevel() >= 4) {
                e.trace(4, "Did not match '" + String.valueOf(this) + "' at " + String.valueOf(e.currentItem()));
            }
        }
        return matches;
    }

    public String toString() {
        return "[" + this.conditionName + "] :- " + this.condition.toString();
    }
}

