/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.hitfield;

import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;

public class RawBase64
implements Comparable<RawBase64> {
    private static final Base64.Encoder encoder = Base64.getEncoder();
    private final byte[] content;

    public RawBase64(byte[] content) {
        Objects.requireNonNull(content);
        this.content = content;
    }

    public byte[] value() {
        return this.content;
    }

    @Override
    public int compareTo(RawBase64 rhs) {
        return Arrays.compareUnsigned(this.content, rhs.content);
    }

    public String toString() {
        return encoder.encodeToString(this.content);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RawBase64 rawBase64 = (RawBase64)o;
        return Arrays.equals(this.content, rawBase64.content);
    }

    public int hashCode() {
        return Arrays.hashCode(this.content);
    }
}

