/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.dispatch;

import com.yahoo.concurrent.Timer;
import com.yahoo.prelude.fastsearch.VespaBackend;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.dispatch.FillInvoker;
import com.yahoo.search.dispatch.InterleavedSearchInvoker;
import com.yahoo.search.dispatch.SearchErrorInvoker;
import com.yahoo.search.dispatch.SearchInvoker;
import com.yahoo.search.dispatch.TopKEstimator;
import com.yahoo.search.dispatch.searchcluster.Group;
import com.yahoo.search.dispatch.searchcluster.Node;
import com.yahoo.search.dispatch.searchcluster.SearchGroups;
import com.yahoo.search.result.Coverage;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.vespa.config.search.DispatchConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public abstract class InvokerFactory {
    private static final double SKEW_FACTOR = 0.05;
    private final SearchGroups cluster;
    private final DispatchConfig dispatchConfig;
    private final TopKEstimator hitEstimator;

    public InvokerFactory(SearchGroups searchCluster, DispatchConfig dispatchConfig) {
        this.cluster = searchCluster;
        this.dispatchConfig = dispatchConfig;
        this.hitEstimator = new TopKEstimator(30.0, dispatchConfig.topKProbability(), 0.05);
    }

    protected abstract Optional<SearchInvoker> createNodeSearchInvoker(VespaBackend var1, Query var2, int var3, Node var4);

    public abstract FillInvoker createFillInvoker(VespaBackend var1, Result var2);

    Optional<SearchInvoker> createSearchInvoker(VespaBackend searcher, Query query, List<Node> nodes, boolean acceptIncompleteCoverage, int maxHits) {
        Group group = this.cluster.get(nodes.get(0).group());
        ArrayList<SearchInvoker> invokers = new ArrayList<SearchInvoker>(nodes.size());
        HashSet<Integer> failed = null;
        for (Node node : nodes) {
            if (node.isWorking() != Boolean.FALSE && !this.createNodeSearchInvoker(searcher, query, maxHits, node).map(invoker -> {
                invokers.add((SearchInvoker)invoker);
                return invoker;
            }).isEmpty()) continue;
            if (failed == null) {
                failed = new HashSet<Integer>();
            }
            failed.add(node.key());
        }
        if (failed != null) {
            ArrayList<Node> success = new ArrayList<Node>(nodes.size() - failed.size());
            for (Node node : nodes) {
                if (failed.contains(node.key())) continue;
                success.add(node);
            }
            if (!this.cluster.isPartialGroupCoverageSufficient(group.hasSufficientCoverage(), success) && !acceptIncompleteCoverage) {
                return Optional.empty();
            }
            if (invokers.isEmpty()) {
                return Optional.of(InvokerFactory.createCoverageErrorInvoker(nodes, failed));
            }
        }
        if (invokers.size() == 1 && failed == null) {
            return Optional.of((SearchInvoker)invokers.get(0));
        }
        return Optional.of(new InterleavedSearchInvoker(Timer.monotonic, invokers, this.hitEstimator, this.dispatchConfig, group, failed));
    }

    protected static SearchInvoker createCoverageErrorInvoker(List<Node> nodes, Set<Integer> failed) {
        StringBuilder down = new StringBuilder("Connection failure on nodes with distribution-keys: ");
        int count = 0;
        for (Node node : nodes) {
            if (!failed.contains(node.key())) continue;
            if (count > 0) {
                down.append(", ");
            }
            ++count;
            down.append(node.key());
        }
        Coverage coverage = new Coverage(0L, 0L, 0);
        coverage.setNodesTried(count);
        return new SearchErrorInvoker(ErrorMessage.createBackendCommunicationError(down.toString()), coverage);
    }
}

