/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.handler;

import com.yahoo.container.handler.Timing;
import com.yahoo.container.logging.HitCounts;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.result.Coverage;
import com.yahoo.search.result.ErrorHit;
import com.yahoo.search.result.ErrorMessage;
import com.yahoo.search.result.Hit;
import java.util.ArrayList;
import java.util.Iterator;

public class SearchResponse {
    static void removeEmptySummaryFeatureFields(Result result) {
        if (!result.hits().getQuery().getRanking().getListFeatures()) {
            Iterator<Hit> i = result.hits().unorderedIterator();
            while (i.hasNext()) {
                i.next().removeField("rankfeatures");
            }
        }
    }

    static void trimHits(Result result) {
        if (result.getConcreteHitCount() > result.hits().getQuery().getHits()) {
            result.hits().trim(0, result.hits().getQuery().getHits());
        }
    }

    static Iterator<? extends ErrorMessage> getErrorIterator(ErrorHit h) {
        if (h == null) {
            return new ArrayList(0).iterator();
        }
        return h.errorIterator();
    }

    static boolean isSuccess(Result result) {
        if (result.hits().getErrorHit() == null) {
            return true;
        }
        for (Hit hit : result.hits()) {
            if (hit.isMeta() || hit.isFillable() && hit.getFilled().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static Timing createTiming(Query query, Result result) {
        long summaryStartTime = result.getElapsedTime().firstFill();
        long queryStartTime = result.getElapsedTime().first();
        return new Timing(summaryStartTime, 0L, queryStartTime == Long.MAX_VALUE ? 0L : queryStartTime, query.getTimeout());
    }

    public static HitCounts createHitCounts(Query query, Result result) {
        Coverage coverage = result.getCoverage(false);
        return coverage != null ? new HitCounts(result.getHitCount(), result.getConcreteHitCount(), result.getTotalHitCount(), query.getHits(), query.getOffset(), coverage.toLoggingCoverage()) : new HitCounts(result.getHitCount(), result.getConcreteHitCount(), result.getTotalHitCount(), query.getHits(), query.getOffset(), null);
    }
}

