/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.federation.sourceref;

import com.google.common.base.Joiner;
import com.yahoo.component.ComponentId;
import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.chain.model.ComponentAdaptor;
import com.yahoo.component.provider.ComponentRegistry;
import com.yahoo.processing.request.Properties;
import com.yahoo.search.federation.sourceref.ResolveResult;
import com.yahoo.search.federation.sourceref.SearchChainInvocationSpec;
import com.yahoo.search.federation.sourceref.Target;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class SourcesTarget
extends Target {
    private final ComponentRegistry<ComponentAdaptor<SearchChainInvocationSpec>> providerSources = new ComponentRegistry<ComponentAdaptor<SearchChainInvocationSpec>>(){};
    private SearchChainInvocationSpec defaultProviderSource;

    public SourcesTarget(ComponentId sourceId) {
        super(sourceId);
    }

    @Override
    public ResolveResult responsibleSearchChain(Properties queryProperties) {
        ComponentSpecification providerSpecification = this.providerSpecificationForSource(queryProperties);
        if (providerSpecification == null) {
            return new ResolveResult(this.defaultProviderSource);
        }
        return this.lookupProviderSource(providerSpecification);
    }

    @Override
    public String searchRefDescription() {
        return this.sourceId().stringValue() + "[provider = " + Joiner.on((String)", ").join(this.allProviderIdsStringValue()) + "]";
    }

    private SortedSet<String> allProviderIdsStringValue() {
        TreeSet<String> result = new TreeSet<String>();
        for (ComponentAdaptor providerSource : this.providerSources.allComponents()) {
            result.add(providerSource.getId().stringValue());
        }
        return result;
    }

    private ResolveResult lookupProviderSource(ComponentSpecification providerSpecification) {
        ComponentAdaptor providerSource = (ComponentAdaptor)this.providerSources.getComponent(providerSpecification);
        if (providerSource == null) {
            return new ResolveResult("No provider '" + String.valueOf(this.sourceId()) + "' for source '" + String.valueOf(providerSpecification) + "'.");
        }
        return new ResolveResult((SearchChainInvocationSpec)providerSource.model);
    }

    @Override
    public void freeze() {
        if (this.defaultProviderSource == null) {
            throw new RuntimeException("Null default provider source for source " + String.valueOf(this.sourceId()) + ".");
        }
        this.providerSources.freeze();
    }

    public void addSource(ComponentId providerId, SearchChainInvocationSpec searchChainInvocationSpec, boolean isDefaultProviderForSource) {
        this.providerSources.register(providerId, (Object)new ComponentAdaptor(providerId, (Object)searchChainInvocationSpec));
        if (isDefaultProviderForSource) {
            this.setDefaultProviderSource(searchChainInvocationSpec);
        }
    }

    private void setDefaultProviderSource(SearchChainInvocationSpec searchChainInvocationSpec) {
        if (this.defaultProviderSource != null) {
            throw new RuntimeException("Tried to set two default providers for source " + String.valueOf(this.sourceId()) + ".");
        }
        this.defaultProviderSource = searchChainInvocationSpec;
    }

    ComponentId sourceId() {
        return this.localId;
    }

    private ComponentSpecification providerSpecificationForSource(Properties queryProperties) {
        String spec = queryProperties.getString("source." + this.sourceId().stringValue() + ".provider");
        return ComponentSpecification.fromString((String)spec);
    }

    public SearchChainInvocationSpec defaultProviderSource() {
        return this.defaultProviderSource;
    }

    public List<SearchChainInvocationSpec> allProviderSources() {
        ArrayList<SearchChainInvocationSpec> allProviderSources = new ArrayList<SearchChainInvocationSpec>();
        for (ComponentAdaptor component : this.providerSources.allComponents()) {
            allProviderSources.add((SearchChainInvocationSpec)component.model);
        }
        return allProviderSources;
    }
}

