/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.query.textserialize.parser;

import com.yahoo.search.query.textserialize.parser.DispatchFormHandler;
import com.yahoo.search.query.textserialize.parser.ParseException;
import com.yahoo.search.query.textserialize.parser.ParserConstants;
import com.yahoo.search.query.textserialize.parser.ParserTokenManager;
import com.yahoo.search.query.textserialize.parser.SimpleCharStream;
import com.yahoo.search.query.textserialize.parser.Token;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Parser
implements ParserConstants {
    private DispatchFormHandler dispatchFormHandler;
    private Object dispatchContext;
    public ParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[4];
    private static int[] jj_la1_0;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public Parser(Reader stream, DispatchFormHandler dispatchFormHandler, Object dispatchContext) {
        this(stream);
        this.dispatchFormHandler = dispatchFormHandler;
        this.dispatchContext = dispatchContext;
    }

    private static String parseString(String in) {
        return Parser.stripEnclosingQuotes(in.replace("\\\\", "\\").replace("\\\"", "\""));
    }

    private static String stripEnclosingQuotes(String in) {
        return in.substring(1, in.length() - 1);
    }

    public final Object start() throws ParseException {
        Object result = this.form();
        this.jj_consume_token(0);
        return result;
    }

    public final Object form() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 7 -> this.dispatchForm();
            case 9 -> this.map();
            case 11 -> this.array();
            case 13, 14, 15, 18 -> this.literal();
            default -> {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final Object literal() throws ParseException {
        return switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 15 -> this.string();
            case 18 -> this.number();
            case 13 -> this.bool();
            case 14 -> this.null_();
            default -> {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        };
    }

    public final String string() throws ParseException {
        Token t = this.jj_consume_token(15);
        return Parser.parseString(t.image);
    }

    public final Double number() throws ParseException {
        Token t = this.jj_consume_token(18);
        return Double.valueOf(t.image);
    }

    public final Boolean bool() throws ParseException {
        Token t = this.jj_consume_token(13);
        if ("on".equals(t.image)) {
            return true;
        }
        return Boolean.valueOf(t.image);
    }

    public final Object null_() throws ParseException {
        this.jj_consume_token(14);
        return null;
    }

    public final Map<Object, Object> map() throws ParseException {
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        this.jj_consume_token(9);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 14: 
                case 15: 
                case 18: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
            }
            Object key = this.form();
            Object value = this.form();
            result.put(key, value);
        }
        this.jj_consume_token(10);
        return result;
    }

    public final Object dispatchForm() throws ParseException {
        this.jj_consume_token(7);
        Token symbol = this.jj_consume_token(22);
        List<Object> arguments = this.forms();
        this.jj_consume_token(8);
        return this.dispatchFormHandler.dispatch(symbol.image, arguments, this.dispatchContext);
    }

    public final List<Object> forms() throws ParseException {
        ArrayList<Object> results = new ArrayList<Object>();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 7: 
                case 9: 
                case 11: 
                case 13: 
                case 14: 
                case 15: 
                case 18: {
                    break;
                }
                default: {
                    this.jj_la1[3] = this.jj_gen;
                    break block3;
                }
            }
            Object value = this.form();
            results.add(value);
        }
        return results;
    }

    public final List<Object> array() throws ParseException {
        this.jj_consume_token(11);
        List<Object> result = this.forms();
        this.jj_consume_token(12);
        return result;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{322176, 319488, 322176, 322176};
    }

    public Parser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        this.token_source = new ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 4; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.reInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 4; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public Parser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 4; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.reInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new ParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 4; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public Parser(ParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 4; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(ParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 4; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            if (t.next == null) {
                t.next = this.token_source.getNextToken();
            }
            t = t.next;
        }
        return t;
    }

    private int jj_ntk_f() {
        int ret;
        this.jj_nt = this.token.next;
        Token nt = this.jj_nt;
        if (nt == null) {
            this.token.next = this.token_source.getNextToken();
            ret = this.jj_ntk = this.token.next.kind;
        } else {
            ret = this.jj_ntk = nt.kind;
        }
        return ret;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[25];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 4; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 25; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return false;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        Parser.jj_la1_init_0();
    }
}

