/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.grouping.request;

import java.util.ArrayList;

public class RawBuffer
implements Comparable<RawBuffer>,
Cloneable {
    private final ArrayList<Byte> buffer;

    public RawBuffer() {
        this.buffer = new ArrayList();
    }

    public RawBuffer(ArrayList<Byte> buffer) {
        this.buffer = buffer;
    }

    public RawBuffer(byte[] bytes) {
        this.buffer = new ArrayList();
        this.put(bytes);
    }

    public RawBuffer put(byte value) {
        this.buffer.add(value);
        return this;
    }

    public RawBuffer put(byte[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.buffer.add(values[i]);
        }
        return this;
    }

    public byte[] getBytes() {
        byte[] ret = new byte[this.buffer.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.buffer.get(i);
        }
        return ret;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("{");
        for (int i = 0; i < this.buffer.size(); ++i) {
            s.append(this.buffer.get(i));
            if (i >= this.buffer.size() - 1) continue;
            s.append(",");
        }
        s.append("}");
        return s.toString();
    }

    public RawBuffer clone() {
        return new RawBuffer(new ArrayList<Byte>(this.buffer));
    }

    @Override
    public int compareTo(RawBuffer rhs) {
        Byte[] my = this.buffer.toArray(new Byte[0]);
        Byte[] their = rhs.buffer.toArray(new Byte[0]);
        for (int i = 0; i < my.length && i < their.length; ++i) {
            if (my[i] < their[i]) {
                return -1;
            }
            if (my[i] <= their[i]) continue;
            return 1;
        }
        return Integer.compare(my.length, their.length);
    }

    public int hashCode() {
        return this.buffer.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RawBuffer)) {
            return false;
        }
        return this.compareTo((RawBuffer)other) == 0;
    }
}

