/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.querytransform;

import com.yahoo.component.chain.dependencies.After;
import com.yahoo.component.chain.dependencies.Before;
import com.yahoo.language.LinguisticsCase;
import com.yahoo.prelude.Index;
import com.yahoo.prelude.IndexFacts;
import com.yahoo.prelude.query.CompositeItem;
import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.NotItem;
import com.yahoo.prelude.query.RankItem;
import com.yahoo.prelude.query.TermItem;
import com.yahoo.prelude.query.WordItem;
import com.yahoo.search.Query;
import com.yahoo.search.Result;
import com.yahoo.search.Searcher;
import com.yahoo.search.searchchain.Execution;
import java.util.ListIterator;

@Before(value={"Stemming"})
@After(value={"unblendedResult"})
public class LiteralBoostSearcher
extends Searcher {
    @Override
    public Result search(Query query, Execution execution) {
        this.addRankTerms(query, execution.context().getIndexFacts().newSession(query));
        return execution.search(query);
    }

    private void addRankTerms(Query query, IndexFacts.Session indexFacts) {
        RankItem newRankTerms = new RankItem();
        this.addLiterals(newRankTerms, query.getModel().getQueryTree().getRoot(), indexFacts);
        if (newRankTerms.getItemCount() > 0) {
            this.addTopLevelRankTerms(newRankTerms, query);
        }
        if (query.getTrace().getLevel() >= 2 && newRankTerms.getItemCount() > 0) {
            query.trace("Added rank terms for possible literal field matches.", true, 2);
        }
    }

    private void addTopLevelRankTerms(RankItem rankTerms, Query query) {
        Item root = query.getModel().getQueryTree().getRoot();
        if (root instanceof RankItem) {
            ListIterator<Item> i = rankTerms.getItemIterator();
            while (i.hasNext()) {
                ((RankItem)root).addItem((Item)i.next());
            }
        } else {
            rankTerms.addItem(0, root);
            query.getModel().getQueryTree().setRoot(rankTerms);
        }
    }

    private void addLiterals(RankItem rankTerms, Item item, IndexFacts.Session indexFacts) {
        TermItem termItem;
        Index index;
        if (item instanceof NotItem) {
            this.addLiterals(rankTerms, ((NotItem)item).getPositiveItem(), indexFacts);
        } else if (item instanceof CompositeItem) {
            ListIterator<Item> i = ((CompositeItem)item).getItemIterator();
            while (i.hasNext()) {
                this.addLiterals(rankTerms, (Item)i.next(), indexFacts);
            }
        } else if (item instanceof TermItem && (index = indexFacts.getIndex((termItem = (TermItem)item).getIndexName())).getLiteralBoost()) {
            rankTerms.addItem(new WordItem(LinguisticsCase.toLowerCase((String)termItem.getRawWord()), index.getName() + "_literal"));
        }
    }
}

