/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.prelude.query;

import com.yahoo.prelude.query.Item;
import com.yahoo.prelude.query.MarkerWordItem;
import com.yahoo.prelude.query.PhraseItem;
import com.yahoo.prelude.query.WordItem;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;

public class UriItem
extends PhraseItem {
    private boolean startAnchorDefault = false;
    private boolean endAnchorDefault = false;
    private String sourceString;

    public UriItem() {
    }

    public UriItem(String indexName) {
        super(indexName);
    }

    public void addStartAnchorItem() {
        this.addItem(0, MarkerWordItem.createStartOfHost(this.getIndexName()));
    }

    public void addEndAnchorItem() {
        this.addItem(MarkerWordItem.createEndOfHost(this.getIndexName()));
    }

    public boolean hasStartAnchor() {
        return this.getItem(0) instanceof MarkerWordItem && ((MarkerWordItem)this.getItem(0)).isStartAnchor();
    }

    public boolean hasEndAnchor() {
        return this.getItem(this.getItemCount() - 1) instanceof MarkerWordItem && ((MarkerWordItem)this.getItem(this.getItemCount() - 1)).isEndAnchor();
    }

    public boolean isStartAnchorDefault() {
        return this.startAnchorDefault;
    }

    public void setStartAnchorDefault(boolean startAnchorDefault) {
        this.startAnchorDefault = startAnchorDefault;
    }

    public boolean isEndAnchorDefault() {
        return this.endAnchorDefault;
    }

    public void setEndAnchorDefault(boolean endAnchorDefault) {
        this.endAnchorDefault = endAnchorDefault;
    }

    public void setSourceString(String sourceString) {
        this.sourceString = sourceString;
    }

    public String getArgumentString() {
        if (this.sourceString != null) {
            return this.sourceString;
        }
        ArrayList<Item> items = new ArrayList<Item>(this.items());
        if (this.hasStartAnchor()) {
            items.remove(0);
        }
        if (this.hasEndAnchor()) {
            items.remove(items.size() - 1);
        }
        return items.stream().map(item -> ((WordItem)item).getWord()).collect(Collectors.joining(" "));
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        UriItem other = (UriItem)o;
        if (this.startAnchorDefault != other.startAnchorDefault) {
            return false;
        }
        if (this.endAnchorDefault != other.endAnchorDefault) {
            return false;
        }
        return Objects.equals(this.sourceString, other.sourceString);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.startAnchorDefault, this.endAnchorDefault, this.sourceString);
    }
}

