/*
 * Decompiled with CFR 0.152.
 */
package ai.onnxruntime;

public class OrtException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final OrtErrorCode errorCode;

    public OrtException(String message) {
        super(message);
        this.errorCode = OrtErrorCode.ORT_JAVA_UNKNOWN;
    }

    public OrtException(int code, String message) {
        this(OrtErrorCode.mapFromInt(code), message);
    }

    public OrtException(OrtErrorCode code, String message) {
        super("Error code - " + (Object)((Object)code) + " - message: " + message);
        this.errorCode = code;
    }

    public OrtErrorCode getCode() {
        return this.errorCode;
    }

    public static enum OrtErrorCode {
        ORT_JAVA_UNKNOWN(-1),
        ORT_OK(0),
        ORT_FAIL(1),
        ORT_INVALID_ARGUMENT(2),
        ORT_NO_SUCHFILE(3),
        ORT_NO_MODEL(4),
        ORT_ENGINE_ERROR(5),
        ORT_RUNTIME_EXCEPTION(6),
        ORT_INVALID_PROTOBUF(7),
        ORT_MODEL_LOADED(8),
        ORT_NOT_IMPLEMENTED(9),
        ORT_INVALID_GRAPH(10),
        ORT_EP_FAIL(11),
        ORT_MODEL_LOAD_CANCELED(12),
        ORT_MODEL_REQUIRES_COMPILATION(13),
        ORT_NOT_FOUND(14);

        private final int value;
        private static final OrtErrorCode[] values;

        private OrtErrorCode(int value) {
            this.value = value;
        }

        public static OrtErrorCode mapFromInt(int value) {
            if (value >= 0 && value < values.length) {
                return values[value];
            }
            return ORT_JAVA_UNKNOWN;
        }

        static {
            values = new OrtErrorCode[15];
            for (OrtErrorCode ot : OrtErrorCode.values()) {
                if (ot == ORT_JAVA_UNKNOWN) continue;
                OrtErrorCode.values[ot.value] = ot;
            }
        }
    }
}

