/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.metric;

import com.yahoo.jdisc.Metric;
import com.yahoo.jdisc.application.MetricConsumer;
import java.util.Map;

public final class ForwardingMetricConsumer
implements MetricConsumer {
    private final MetricConsumer[] consumers;

    public ForwardingMetricConsumer(MetricConsumer[] consumers) {
        this.consumers = consumers;
    }

    public void set(String key, Number val, Metric.Context ctx) {
        ForwardingContext fwd = (ForwardingContext)ctx;
        for (int i = 0; i < this.consumers.length; ++i) {
            this.consumers[i].set(key, val, fwd != null ? fwd.contexts[i] : null);
        }
    }

    public void add(String key, Number val, Metric.Context ctx) {
        ForwardingContext fwd = (ForwardingContext)ctx;
        for (int i = 0; i < this.consumers.length; ++i) {
            this.consumers[i].add(key, val, fwd != null ? fwd.contexts[i] : null);
        }
    }

    public Metric.Context createContext(Map<String, ?> properties) {
        Metric.Context[] contexts = new Metric.Context[this.consumers.length];
        for (int i = 0; i < this.consumers.length; ++i) {
            contexts[i] = this.consumers[i].createContext(properties);
        }
        return new ForwardingContext(contexts);
    }

    private static class ForwardingContext
    implements Metric.Context {
        final Metric.Context[] contexts;

        ForwardingContext(Metric.Context[] contexts) {
            this.contexts = contexts;
        }
    }
}

