/*
 * Decompiled with CFR 0.152.
 */
package ai.vespa.secret.model;

import ai.vespa.secret.model.SecretName;
import ai.vespa.secret.model.VaultName;
import java.util.Objects;

public record Key(VaultName vaultName, SecretName secretName) {
    public Key {
        Objects.requireNonNull(vaultName, "vaultName cannot be null");
        Objects.requireNonNull(secretName, "secretName cannot be null");
    }

    public Key(String keyGroup, String keyName) {
        this(VaultName.of(keyGroup), SecretName.of(keyName));
    }

    @Override
    public String toString() {
        return this.vaultName.value() + "/" + this.secretName.value();
    }

    public static Key fromString(String key) {
        String[] parts = key.split("/");
        if (parts.length != 2) {
            throw new IllegalArgumentException("Key must be on the form 'vaultName/secretName'");
        }
        return new Key(VaultName.of(parts[0]), SecretName.of(parts[1]));
    }

    public String keyGroup() {
        return this.vaultName.value();
    }

    public String keyName() {
        return this.secretName.value();
    }
}

