/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc.state;

import com.yahoo.component.AbstractComponent;
import com.yahoo.component.annotation.Inject;
import com.yahoo.container.jdisc.config.HealthMonitorConfig;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StateMonitor
extends AbstractComponent {
    private static final Logger log = Logger.getLogger(StateMonitor.class.getName());
    private volatile Status status;

    @Inject
    public StateMonitor(HealthMonitorConfig config) {
        this.status = Status.valueOf(config.initialStatus());
    }

    public static StateMonitor createForTesting() {
        return new StateMonitor(new HealthMonitorConfig.Builder().build());
    }

    public void status(Status status) {
        if (status != this.status) {
            log.log(Level.INFO, "Changing health status code from '" + String.valueOf((Object)this.status) + "' to '" + status.name() + "'");
            this.status = status;
        }
    }

    public Status status() {
        return this.status;
    }

    public static enum Status {
        up,
        down,
        initializing;

    }
}

