/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.core.document;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class ContainerDocumentConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "9e77c8ce4ee1555c611eb03cc419daa7";
    public static final String CONFIG_DEF_NAME = "container-document";
    public static final String CONFIG_DEF_NAMESPACE = "container.core.document";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=container.core.document", "doctype[].type string", "doctype[].factorycomponent string"};
    private final InnerNodeVector<Doctype> doctype;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public ContainerDocumentConfig(Builder builder) {
        this(builder, true);
    }

    private ContainerDocumentConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for container-document must be initialized: " + String.valueOf(builder.__uninitialized));
        }
        this.doctype = Doctype.createVector(builder.doctype);
    }

    public List<Doctype> doctype() {
        return this.doctype;
    }

    public Doctype doctype(int i) {
        return (Doctype)((Object)this.doctype.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ContainerDocumentConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Doctype.Builder> doctype = new ArrayList<Doctype.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(ContainerDocumentConfig config) {
            for (Doctype d : config.doctype()) {
                this.doctype(new Doctype.Builder(d));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.doctype.isEmpty()) {
                this.doctype.addAll(__superior.doctype);
            }
            return this;
        }

        public Builder doctype(Doctype.Builder __builder) {
            this.doctype.add(__builder);
            return this;
        }

        public Builder doctype(Consumer<Doctype.Builder> __func) {
            Doctype.Builder __inner = new Doctype.Builder();
            __func.accept(__inner);
            this.doctype.add(__inner);
            return this;
        }

        public Builder doctype(List<Doctype.Builder> __builders) {
            this.doctype = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return ContainerDocumentConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return ContainerDocumentConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return ContainerDocumentConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public ContainerDocumentConfig build() {
            return new ContainerDocumentConfig(this);
        }
    }

    public static final class Doctype
    extends InnerNode {
        private final StringNode type;
        private final StringNode factorycomponent;

        public Doctype(Builder builder) {
            this(builder, true);
        }

        private Doctype(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for container-document.doctype[] must be initialized: " + String.valueOf(builder.__uninitialized));
            }
            this.type = builder.type == null ? new StringNode() : new StringNode(builder.type);
            this.factorycomponent = builder.factorycomponent == null ? new StringNode() : new StringNode(builder.factorycomponent);
        }

        public String type() {
            return this.type.value();
        }

        public String factorycomponent() {
            return this.factorycomponent.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Doctype newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("doctype");
            return changes;
        }

        private static InnerNodeVector<Doctype> createVector(List<Builder> builders) {
            ArrayList<Doctype> elems = new ArrayList<Doctype>();
            for (Builder b : builders) {
                elems.add(new Doctype(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(List.of("type", "factorycomponent"));
            private String type = null;
            private String factorycomponent = null;

            public Builder() {
            }

            public Builder(Doctype config) {
                this.type(config.type());
                this.factorycomponent(config.factorycomponent());
            }

            private Builder override(Builder __superior) {
                if (__superior.type != null) {
                    this.type(__superior.type);
                }
                if (__superior.factorycomponent != null) {
                    this.factorycomponent(__superior.factorycomponent);
                }
                return this;
            }

            public Builder type(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.type = __value;
                this.__uninitialized.remove("type");
                return this;
            }

            public Builder factorycomponent(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.factorycomponent = __value;
                this.__uninitialized.remove("factorycomponent");
                return this;
            }

            public Doctype build() {
                return new Doctype(this);
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

