/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.ssl.impl;

import com.yahoo.component.annotation.Inject;
import com.yahoo.jdisc.http.ConnectorConfig;
import com.yahoo.jdisc.http.server.jetty.DataplaneProxyCredentials;
import com.yahoo.jdisc.http.ssl.impl.ConfiguredSslContextFactoryProvider;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Optional;

public class CloudTokenSslContextProvider
extends ConfiguredSslContextFactoryProvider {
    private final DataplaneProxyCredentials dataplaneProxyCredentials;

    @Inject
    public CloudTokenSslContextProvider(ConnectorConfig connectorConfig, DataplaneProxyCredentials dataplaneProxyCredentials) {
        super(connectorConfig);
        this.dataplaneProxyCredentials = dataplaneProxyCredentials;
    }

    @Override
    Optional<String> getCaCertificates(ConnectorConfig.Ssl sslConfig) {
        try {
            return Optional.of(Files.readString(this.dataplaneProxyCredentials.certificateFile(), StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Dataplane proxy certificate not available", e);
        }
    }
}

