// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.container.core.identity;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of identity
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class IdentityConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "a9afe15151893e92c9d7906cae5e740a";
  public final static String CONFIG_DEF_NAME = "identity";
  public final static String CONFIG_DEF_NAMESPACE = "container.core.identity";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=container.core.identity",
    "domain string",
    "service string",
    "nodeIdentityName string",
    "configserverIdentityName string",
    "loadBalancerAddress string",
    "athenzDnsSuffix string",
    "ztsUrl string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>(List.of(
      "domain",
      "service",
      "nodeIdentityName",
      "configserverIdentityName",
      "loadBalancerAddress",
      "athenzDnsSuffix",
      "ztsUrl"
      ));

    private String domain = null;
    private String service = null;
    private String nodeIdentityName = null;
    private String configserverIdentityName = null;
    private String loadBalancerAddress = null;
    private String athenzDnsSuffix = null;
    private String ztsUrl = null;

    public Builder() { }

    public Builder(IdentityConfig config) {
      domain(config.domain());
      service(config.service());
      nodeIdentityName(config.nodeIdentityName());
      configserverIdentityName(config.configserverIdentityName());
      loadBalancerAddress(config.loadBalancerAddress());
      athenzDnsSuffix(config.athenzDnsSuffix());
      ztsUrl(config.ztsUrl());
    }

    private Builder override(Builder __superior) {
      if (__superior.domain != null)
        domain(__superior.domain);
      if (__superior.service != null)
        service(__superior.service);
      if (__superior.nodeIdentityName != null)
        nodeIdentityName(__superior.nodeIdentityName);
      if (__superior.configserverIdentityName != null)
        configserverIdentityName(__superior.configserverIdentityName);
      if (__superior.loadBalancerAddress != null)
        loadBalancerAddress(__superior.loadBalancerAddress);
      if (__superior.athenzDnsSuffix != null)
        athenzDnsSuffix(__superior.athenzDnsSuffix);
      if (__superior.ztsUrl != null)
        ztsUrl(__superior.ztsUrl);
      return this;
    }

    public Builder domain(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      domain = __value;
      __uninitialized.remove("domain");
      return this;
    }


    public Builder service(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      service = __value;
      __uninitialized.remove("service");
      return this;
    }


    public Builder nodeIdentityName(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      nodeIdentityName = __value;
      __uninitialized.remove("nodeIdentityName");
      return this;
    }


    public Builder configserverIdentityName(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      configserverIdentityName = __value;
      __uninitialized.remove("configserverIdentityName");
      return this;
    }


    public Builder loadBalancerAddress(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      loadBalancerAddress = __value;
      __uninitialized.remove("loadBalancerAddress");
      return this;
    }


    public Builder athenzDnsSuffix(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      athenzDnsSuffix = __value;
      __uninitialized.remove("athenzDnsSuffix");
      return this;
    }


    public Builder ztsUrl(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      ztsUrl = __value;
      __uninitialized.remove("ztsUrl");
      return this;
    }


    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public IdentityConfig build() {
      return new IdentityConfig(this);
    }

  }

  // Tenant identity domain name
  private final StringNode domain;
  // Tenant identity service name
  private final StringNode service;
  private final StringNode nodeIdentityName;
  private final StringNode configserverIdentityName;
  private final StringNode loadBalancerAddress;
  private final StringNode athenzDnsSuffix;
  private final StringNode ztsUrl;

  public IdentityConfig(Builder builder) {
    this(builder, true);
  }

  private IdentityConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "identity must be initialized: " + builder.__uninitialized);

    domain = (builder.domain == null) ?
        new StringNode() : new StringNode(builder.domain);
    service = (builder.service == null) ?
        new StringNode() : new StringNode(builder.service);
    nodeIdentityName = (builder.nodeIdentityName == null) ?
        new StringNode() : new StringNode(builder.nodeIdentityName);
    configserverIdentityName = (builder.configserverIdentityName == null) ?
        new StringNode() : new StringNode(builder.configserverIdentityName);
    loadBalancerAddress = (builder.loadBalancerAddress == null) ?
        new StringNode() : new StringNode(builder.loadBalancerAddress);
    athenzDnsSuffix = (builder.athenzDnsSuffix == null) ?
        new StringNode() : new StringNode(builder.athenzDnsSuffix);
    ztsUrl = (builder.ztsUrl == null) ?
        new StringNode() : new StringNode(builder.ztsUrl);
  }

  /**
   * @return identity.domain
   */
  public String domain() {
    return domain.value();
  }

  /**
   * @return identity.service
   */
  public String service() {
    return service.value();
  }

  /**
   * @return identity.nodeIdentityName
   */
  public String nodeIdentityName() {
    return nodeIdentityName.value();
  }

  /**
   * @return identity.configserverIdentityName
   */
  public String configserverIdentityName() {
    return configserverIdentityName.value();
  }

  /**
   * @return identity.loadBalancerAddress
   */
  public String loadBalancerAddress() {
    return loadBalancerAddress.value();
  }

  /**
   * @return identity.athenzDnsSuffix
   */
  public String athenzDnsSuffix() {
    return athenzDnsSuffix.value();
  }

  /**
   * @return identity.ztsUrl
   */
  public String ztsUrl() {
    return ztsUrl.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(IdentityConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("identity");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
