// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.container.core.http;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of http-filter
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class HttpFilterConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "cd0b95afb1cf02b1e87a261b86b76dd8";
  public final static String CONFIG_DEF_NAME = "http-filter";
  public final static String CONFIG_DEF_NAMESPACE = "container.core.http";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=container.core.http",
    "param[].name string",
    "param[].value string",
    "filterName string default=\"\"",
    "filterClass string default=\"\""
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Param.Builder> param = new ArrayList<>();
    private String filterName = null;
    private String filterClass = null;

    public Builder() { }

    public Builder(HttpFilterConfig config) {
      for (Param p : config.param()) {
        param(new Param.Builder(p));
      }
      filterName(config.filterName());
      filterClass(config.filterClass());
    }

    private Builder override(Builder __superior) {
      if (!__superior.param.isEmpty())
        param.addAll(__superior.param);
      if (__superior.filterName != null)
        filterName(__superior.filterName);
      if (__superior.filterClass != null)
        filterClass(__superior.filterClass);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Param builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder param(Param.Builder __builder) {
      param.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder param(java.util.function.Consumer<Param.Builder> __func) {
      Param.Builder __inner = new Param.Builder();
      __func.accept(__inner);
      param.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Param builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder param(List<Param.Builder> __builders) {
      param = __builders;
      return this;
    }

    public Builder filterName(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      filterName = __value;
      return this;
    }


    public Builder filterClass(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      filterClass = __value;
      return this;
    }


    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public HttpFilterConfig build() {
      return new HttpFilterConfig(this);
    }

  }

  private final InnerNodeVector<Param> param;
  private final StringNode filterName;
  private final StringNode filterClass;

  public HttpFilterConfig(Builder builder) {
    this(builder, true);
  }

  private HttpFilterConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "http-filter must be initialized: " + builder.__uninitialized);

    param = Param.createVector(builder.param);
    filterName = (builder.filterName == null) ?
        new StringNode("") : new StringNode(builder.filterName);
    filterClass = (builder.filterClass == null) ?
        new StringNode("") : new StringNode(builder.filterClass);
  }

  /**
   * @return http-filter.param[]
   */
  public List<Param> param() {
    return param;
  }

  /**
   * @param i the index of the value to return
   * @return http-filter.param[]
   */
  public Param param(int i) {
    return param.get(i);
  }

  /**
   * @return http-filter.filterName
   */
  public String filterName() {
    return filterName.value();
  }

  /**
   * @return http-filter.filterClass
   */
  public String filterClass() {
    return filterClass.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(HttpFilterConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("http-filter");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents http-filter.param[]
   */
  public final static class Param extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "name",
        "value"
        ));

      private String name = null;
      private String value = null;

      public Builder() { }

      public Builder(Param config) {
        name(config.name());
        value(config.value());
      }

      private Builder override(Builder __superior) {
        if (__superior.name != null)
          name(__superior.name);
        if (__superior.value != null)
          value(__superior.value);
        return this;
      }

      public Builder name(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        name = __value;
        __uninitialized.remove("name");
        return this;
      }


      public Builder value(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        value = __value;
        __uninitialized.remove("value");
        return this;
      }


      public Param build() {
        return new Param(this);
      }

    }

    private final StringNode name;
    private final StringNode value;

    public Param(Builder builder) {
      this(builder, true);
    }

    private Param(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "http-filter.param[] must be initialized: " + builder.__uninitialized);

      name = (builder.name == null) ?
          new StringNode() : new StringNode(builder.name);
      value = (builder.value == null) ?
          new StringNode() : new StringNode(builder.value);
    }

    /**
     * @return http-filter.param[].name
     */
    public String name() {
      return name.value();
    }

    /**
     * @return http-filter.param[].value
     */
    public String value() {
      return value.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Param newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("param");
      return changes;
    }

    private static InnerNodeVector<Param> createVector(List<Builder> builders) {
        List<Param> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Param(b));
        }
        return new InnerNodeVector<Param>(elems);
    }
  }

}
