// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.container.core.document;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of container-document
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 *  
 * Container settings for document type management
 *  
 */
public final class ContainerDocumentConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "9e77c8ce4ee1555c611eb03cc419daa7";
  public final static String CONFIG_DEF_NAME = "container-document";
  public final static String CONFIG_DEF_NAMESPACE = "container.core.document";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=container.core.document",
    "doctype[].type string",
    "doctype[].factorycomponent string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    public List<Doctype.Builder> doctype = new ArrayList<>();

    public Builder() { }

    public Builder(ContainerDocumentConfig config) {
      for (Doctype d : config.doctype()) {
        doctype(new Doctype.Builder(d));
      }
    }

    private Builder override(Builder __superior) {
      if (!__superior.doctype.isEmpty())
        doctype.addAll(__superior.doctype);
      return this;
    }

    /**
     * Add the given builder to this builder's list of Doctype builders
     * @param __builder a builder
     * @return this builder
     */
    public Builder doctype(Doctype.Builder __builder) {
      doctype.add(__builder);
      return this;
    }

    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder doctype(java.util.function.Consumer<Doctype.Builder> __func) {
      Doctype.Builder __inner = new Doctype.Builder();
      __func.accept(__inner);
      doctype.add(__inner);
      return this;
    }

    /**
     * Set the given list as this builder's list of Doctype builders
     * @param __builders a list of builders
     * @return this builder
     */
    public Builder doctype(List<Doctype.Builder> __builders) {
      doctype = __builders;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public ContainerDocumentConfig build() {
      return new ContainerDocumentConfig(this);
    }

  }

  private final InnerNodeVector<Doctype> doctype;

  public ContainerDocumentConfig(Builder builder) {
    this(builder, true);
  }

  private ContainerDocumentConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "container-document must be initialized: " + builder.__uninitialized);

    doctype = Doctype.createVector(builder.doctype);
  }

  /**
   * @return container-document.doctype[]
   */
  public List<Doctype> doctype() {
    return doctype;
  }

  /**
   * @param i the index of the value to return
   * @return container-document.doctype[]
   */
  public Doctype doctype(int i) {
    return doctype.get(i);
  }

  private ChangesRequiringRestart getChangesRequiringRestart(ContainerDocumentConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("container-document");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents container-document.doctype[]
   */
  public final static class Doctype extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>(List.of(
        "type",
        "factorycomponent"
        ));

      private String type = null;
      private String factorycomponent = null;

      public Builder() { }

      public Builder(Doctype config) {
        type(config.type());
        factorycomponent(config.factorycomponent());
      }

      private Builder override(Builder __superior) {
        if (__superior.type != null)
          type(__superior.type);
        if (__superior.factorycomponent != null)
          factorycomponent(__superior.factorycomponent);
        return this;
      }

      public Builder type(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        type = __value;
        __uninitialized.remove("type");
        return this;
      }


      public Builder factorycomponent(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        factorycomponent = __value;
        __uninitialized.remove("factorycomponent");
        return this;
      }


      public Doctype build() {
        return new Doctype(this);
      }

    }

    // A document type name to use a concrete document type for
    private final StringNode type;
    // The component id of the AbstractConcreteDocumentFactory to use to instantiate the concrete document type
    private final StringNode factorycomponent;

    public Doctype(Builder builder) {
      this(builder, true);
    }

    private Doctype(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "container-document.doctype[] must be initialized: " + builder.__uninitialized);

      type = (builder.type == null) ?
          new StringNode() : new StringNode(builder.type);
      factorycomponent = (builder.factorycomponent == null) ?
          new StringNode() : new StringNode(builder.factorycomponent);
    }

    /**
     * @return container-document.doctype[].type
     */
    public String type() {
      return type.value();
    }

    /**
     * @return container-document.doctype[].factorycomponent
     */
    public String factorycomponent() {
      return factorycomponent.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Doctype newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("doctype");
      return changes;
    }

    private static InnerNodeVector<Doctype> createVector(List<Builder> builders) {
        List<Doctype> elems = new ArrayList<>();
        for (Builder b : builders) {
            elems.add(new Doctype(b));
        }
        return new InnerNodeVector<Doctype>(elems);
    }
  }

}
