/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.ssl.impl;

import com.yahoo.component.AbstractComponent;
import com.yahoo.jdisc.http.SslProvider;
import com.yahoo.security.tls.TlsContext;
import java.util.List;
import javax.net.ssl.SSLParameters;

public abstract class TlsContextBasedProvider
extends AbstractComponent
implements SslProvider {
    protected abstract TlsContext getTlsContext(String var1, int var2);

    @Override
    public void configureSsl(SslProvider.ConnectorSsl ssl, String name, int port) {
        TlsContext tlsContext = this.getTlsContext(name, port);
        SSLParameters parameters = tlsContext.parameters();
        ssl.setSslContext(tlsContext.sslContext().context());
        ssl.setEnabledProtocolVersions(List.of(parameters.getProtocols()));
        ssl.setEnabledCipherSuites(List.of(parameters.getCipherSuites()));
        if (parameters.getNeedClientAuth()) {
            ssl.setClientAuth(SslProvider.ConnectorSsl.ClientAuth.NEED);
        } else if (parameters.getWantClientAuth()) {
            ssl.setClientAuth(SslProvider.ConnectorSsl.ClientAuth.WANT);
        } else {
            ssl.setClientAuth(SslProvider.ConnectorSsl.ClientAuth.DISABLED);
        }
    }
}

