/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http.ssl.impl;

import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.eclipse.jetty.util.ssl.SslContextFactory;

class SslContextFactoryUtils {
    SslContextFactoryUtils() {
    }

    static void setEnabledCipherSuites(SslContextFactory factory, SSLContext sslContextOrNull, List<String> enabledCiphers) {
        String[] supportedCiphers = SslContextFactoryUtils.supportedSslParams(sslContextOrNull).getCipherSuites();
        factory.setIncludeCipherSuites((String[])enabledCiphers.toArray(String[]::new));
        factory.setExcludeCipherSuites(SslContextFactoryUtils.createExclusionList(enabledCiphers, supportedCiphers));
    }

    static void setEnabledProtocols(SslContextFactory factory, SSLContext sslContextOrNull, List<String> enabledProtocols) {
        String[] supportedProtocols = SslContextFactoryUtils.supportedSslParams(sslContextOrNull).getProtocols();
        factory.setIncludeProtocols((String[])enabledProtocols.toArray(String[]::new));
        factory.setExcludeProtocols(SslContextFactoryUtils.createExclusionList(enabledProtocols, supportedProtocols));
    }

    private static String[] createExclusionList(List<String> enabledValues, String[] supportedValues) {
        return (String[])Arrays.stream(supportedValues).filter(supportedValue -> !enabledValues.contains(supportedValue)).toArray(String[]::new);
    }

    private static SSLParameters supportedSslParams(SSLContext ctx) {
        try {
            return ctx != null ? ctx.getSupportedSSLParameters() : SSLContext.getDefault().getSupportedSSLParameters();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

