/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.jdisc;

import com.yahoo.container.logging.AccessLogEntry;
import com.yahoo.jdisc.Container;
import com.yahoo.jdisc.References;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.ResourceReference;
import com.yahoo.jdisc.handler.RequestHandler;
import com.yahoo.jdisc.http.HttpRequest;
import com.yahoo.jdisc.http.server.jetty.AccessLoggingRequestHandler;
import com.yahoo.jdisc.service.CurrentContainer;
import com.yahoo.processing.request.Properties;
import java.io.InputStream;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class HttpRequest {
    private final com.yahoo.jdisc.http.HttpRequest parentRequest;
    private final Map<String, String> properties;
    private final InputStream requestData;

    public HttpRequest(com.yahoo.jdisc.http.HttpRequest jdiscHttpRequest, InputStream requestData) {
        this(jdiscHttpRequest, requestData, null);
    }

    public HttpRequest(com.yahoo.jdisc.http.HttpRequest jdiscHttpRequest, InputStream requestData, Map<String, String> propertyOverrides) {
        this.parentRequest = jdiscHttpRequest;
        this.requestData = requestData;
        this.properties = HttpRequest.copyProperties(jdiscHttpRequest.parameters(), propertyOverrides);
    }

    public static HttpRequest createRequest(CurrentContainer container, URI uri, HttpRequest.Method method, InputStream requestData) {
        return HttpRequest.createRequest(container, uri, method, requestData, null);
    }

    public static HttpRequest createRequest(CurrentContainer container, URI uri, HttpRequest.Method method, InputStream requestData, Map<String, String> properties) {
        com.yahoo.jdisc.http.HttpRequest clientRequest = com.yahoo.jdisc.http.HttpRequest.newClientRequest(new Request(container, uri), uri, method);
        HttpRequest.setProperties(clientRequest, properties);
        return new HttpRequest(clientRequest, requestData);
    }

    private static void setProperties(com.yahoo.jdisc.http.HttpRequest clientRequest, Map<String, String> properties) {
        if (properties == null) {
            return;
        }
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            clientRequest.parameters().put(entry.getKey(), HttpRequest.wrap(entry.getValue()));
        }
    }

    private static List<String> wrap(String value) {
        ArrayList<String> l = new ArrayList<String>(4);
        l.add(value);
        return l;
    }

    public static Optional<HttpRequest> getHttpRequest(com.yahoo.processing.Request processingRequest) {
        Properties requestProperties = processingRequest.properties();
        return Optional.ofNullable((HttpRequest)requestProperties.get(com.yahoo.processing.Request.JDISC_REQUEST));
    }

    public Optional<AccessLogEntry> getAccessLogEntry() {
        return Optional.of(this.getJDiscRequest()).flatMap(AccessLoggingRequestHandler::getAccessLogEntry);
    }

    private static URI createUri(String request) {
        URI uri;
        try {
            uri = new URI(request);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        return uri;
    }

    public static HttpRequest createTestRequest(String uri, HttpRequest.Method method) {
        return HttpRequest.createTestRequest(uri, method, null);
    }

    public static HttpRequest createTestRequest(String uri, HttpRequest.Method method, InputStream requestData) {
        return HttpRequest.createTestRequest(uri, method, requestData, null);
    }

    public static HttpRequest createTestRequest(String uri, HttpRequest.Method method, InputStream requestData, Map<String, String> properties) {
        return HttpRequest.createRequest(new MockCurrentContainer(), HttpRequest.createUri(uri), method, requestData, properties);
    }

    private static Map<String, String> copyProperties(Map<String, List<String>> parameters, Map<String, String> parameterMask) {
        Map mask = Objects.requireNonNullElse(parameterMask, Map.of());
        HashMap<String, String> view = new HashMap<String, String>(parameters.size() + mask.size());
        for (Map.Entry<String, List<String>> parameter : parameters.entrySet()) {
            if (!HttpRequest.existsAsOriginalParameter(parameter.getValue())) continue;
            List<String> values = parameter.getValue();
            view.put(parameter.getKey(), values.get(values.size() - 1));
        }
        view.putAll(mask);
        return Collections.unmodifiableMap(view);
    }

    private static boolean existsAsOriginalParameter(List<String> value) {
        return value != null && value.size() > 0 && value.get(0) != null;
    }

    public HttpRequest.Method getMethod() {
        return this.parentRequest.getMethod();
    }

    public URI getUri() {
        return this.parentRequest.getUri();
    }

    public com.yahoo.jdisc.http.HttpRequest getJDiscRequest() {
        return this.parentRequest;
    }

    public Map<String, Object> context() {
        return this.parentRequest.context();
    }

    public long creationTime(TimeUnit unit) {
        return this.parentRequest.creationTime(unit);
    }

    public long getConnectedAt(TimeUnit unit) {
        return this.parentRequest.getConnectedAt(unit);
    }

    public long relativeCreatedAtNanoTime() {
        return this.parentRequest.relativeCreatedAtNanoTime();
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public Map<String, String> propertyMap() {
        return this.properties;
    }

    public boolean getBooleanProperty(String name) {
        if (this.getProperty(name) == null) {
            return false;
        }
        return Boolean.parseBoolean(this.getProperty(name));
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public String getHeader(String name) {
        if (this.parentRequest.headers().get((Object)name) == null) {
            return null;
        }
        return (String)this.parentRequest.headers().get((Object)name).get(0);
    }

    public String getHost() {
        return this.getUri().getHost();
    }

    public int getPort() {
        return this.getUri().getPort();
    }

    public InputStream getData() {
        return this.requestData;
    }

    private static class MockCurrentContainer
    implements CurrentContainer {
        private MockCurrentContainer() {
        }

        public Container newReference(URI uri) {
            return new Container(){

                public RequestHandler resolveHandler(Request request) {
                    return null;
                }

                public <T> T getInstance(Class<T> tClass) {
                    return null;
                }

                public ResourceReference refer() {
                    return References.NOOP_REFERENCE;
                }

                public void release() {
                }

                public long currentTimeMillis() {
                    return System.currentTimeMillis();
                }
            };
        }
    }

    public static class Builder {
        private final HttpRequest parent;
        private com.yahoo.jdisc.http.HttpRequest jdiscRequest;
        HttpRequest.Method method = null;
        HttpRequest.Version version = null;
        Map<String, String> properties = new HashMap<String, String>();
        InputStream requestData = null;
        URI uri = null;
        CurrentContainer container = null;
        private static final String nag = " must be set before the attempted operation.";
        SocketAddress remoteAddress;

        private void boom(Object ref, String what) {
            if (ref == null) {
                throw new IllegalStateException(what + nag);
            }
        }

        private void requireUri() {
            this.boom(this.uri, "An URI");
        }

        private void requireContainer() {
            this.boom(this.container, "A CurrentContainer instance");
        }

        private void ensureJdiscParent() {
            if (this.jdiscRequest == null) {
                if (this.parent == null) {
                    throw new IllegalStateException("Neither another HttpRequest nor JDisc request available.");
                }
                this.jdiscRequest = this.parent.getJDiscRequest();
            }
        }

        private void ensureRequestData() {
            if (this.requestData == null) {
                if (this.parent == null) {
                    throw new IllegalStateException("Neither another HttpRequest nor request data input stream available.");
                }
                this.requestData = this.parent.getData();
            }
        }

        public Builder(HttpRequest request) {
            this(request, request.getJDiscRequest());
        }

        public Builder(com.yahoo.jdisc.http.HttpRequest request) {
            this(null, request);
        }

        private Builder(HttpRequest parent, com.yahoo.jdisc.http.HttpRequest jdiscRequest) {
            this.parent = parent;
            this.jdiscRequest = jdiscRequest;
            this.populateProperties();
        }

        private void populateProperties() {
            if (this.parent == null) {
                return;
            }
            this.properties.putAll(this.parent.propertyMap());
        }

        public Builder put(String key, String value) {
            this.properties.put(key, value);
            return this;
        }

        public Builder removeProperty(String parameterName) {
            this.properties.remove(parameterName);
            return this;
        }

        public Builder method(HttpRequest.Method method) {
            this.method = method;
            return this;
        }

        public Builder jdiscRequest(com.yahoo.jdisc.http.HttpRequest request) {
            this.jdiscRequest = request;
            return this;
        }

        public Builder requestData(InputStream requestData) {
            this.requestData = requestData;
            return this;
        }

        public Builder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public HttpRequest createDirectRequest() {
            this.ensureRequestData();
            this.ensureJdiscParent();
            return new HttpRequest(this.jdiscRequest, this.requestData, this.properties);
        }

        public HttpRequest createClientRequest() {
            this.ensureJdiscParent();
            this.requireUri();
            com.yahoo.jdisc.http.HttpRequest clientRequest = this.method == null ? com.yahoo.jdisc.http.HttpRequest.newClientRequest(this.jdiscRequest, this.uri) : (this.version == null ? com.yahoo.jdisc.http.HttpRequest.newClientRequest(this.jdiscRequest, this.uri, this.method) : com.yahoo.jdisc.http.HttpRequest.newClientRequest(this.jdiscRequest, this.uri, this.method, this.version));
            this.setParameters(clientRequest);
            return new HttpRequest(clientRequest, this.requestData, this.properties);
        }

        public HttpRequest createServerRequest() {
            this.requireUri();
            this.requireContainer();
            com.yahoo.jdisc.http.HttpRequest serverRequest = this.method == null ? com.yahoo.jdisc.http.HttpRequest.newServerRequest(this.container, this.uri) : (this.version == null ? com.yahoo.jdisc.http.HttpRequest.newServerRequest(this.container, this.uri, this.method) : (this.remoteAddress == null ? com.yahoo.jdisc.http.HttpRequest.newServerRequest(this.container, this.uri, this.method, this.version) : com.yahoo.jdisc.http.HttpRequest.newServerRequest(this.container, this.uri, this.method, this.version, this.remoteAddress)));
            this.setParameters(serverRequest);
            return new HttpRequest(serverRequest, this.requestData, this.properties);
        }

        private void setParameters(com.yahoo.jdisc.http.HttpRequest request) {
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                request.parameters().put(entry.getKey(), HttpRequest.wrap(entry.getValue()));
            }
        }
    }
}

