// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.jdisc.http;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of connector
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class ConnectorConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "55e7a63f67993c9e0339c3f2d22c1614";
  public final static String CONFIG_DEF_NAME = "connector";
  public final static String CONFIG_DEF_NAMESPACE = "jdisc.http";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=jdisc.http",
    "listenPort int default=0",
    "name string default=\"default\"",
    "headerCacheSize int default=512",
    "outputBufferSize int default=65536",
    "requestHeaderSize int default=65536",
    "responseHeaderSize int default=65536",
    "acceptQueueSize int default=0",
    "maxContentSize long default=-1",
    "maxContentSizeErrorMessageTemplate string default=\"Request content length %1$d exceeds limit of %2$d bytes\"",
    "reuseAddress bool default=true",
    "idleTimeout double default=180.0",
    "shutdownIdleTimeout double default=1.0",
    "tcpKeepAliveEnabled bool default=false",
    "tcpNoDelay bool default=true",
    "throttling.enabled bool default=false",
    "throttling.maxConnections int default=-1",
    "throttling.maxHeapUtilization double default=-1.0",
    "throttling.maxAcceptRate int default=-1",
    "throttling.idleTimeout double default=-1.0",
    "implicitTlsEnabled bool default=true",
    "ssl.enabled bool default=false",
    "ssl.privateKeyFile string default=\"\"",
    "ssl.privateKey string default=\"\"",
    "ssl.certificateFile string default=\"\"",
    "ssl.certificate string default=\"\"",
    "ssl.caCertificateFile string default=\"\"",
    "ssl.caCertificate string default=\"\"",
    "ssl.clientAuth enum { DISABLED, WANT_AUTH, NEED_AUTH } default=DISABLED",
    "ssl.enabledCipherSuites[] string",
    "ssl.enabledProtocols[] string",
    "tlsClientAuthEnforcer.enable bool default=false",
    "tlsClientAuthEnforcer.pathWhitelist[] string",
    "healthCheckProxy.enable bool default=false",
    "healthCheckProxy.port int default=8080",
    "healthCheckProxy.clientTimeout double default=1.0",
    "healthCheckProxy.handlerTimeout double default=1.5",
    "healthCheckProxy.cacheExpiry double default=1.0",
    "proxyProtocol.enabled bool default=false",
    "proxyProtocol.mixedMode bool default=false",
    "maxRequestsPerConnection int default=0",
    "maxConnectionLife double default=0.0",
    "http2Enabled bool default=true",
    "http2.streamIdleTimeout double default=600",
    "http2.maxConcurrentStreams int default=512",
    "serverName.fallback string default=\"\"",
    "serverName.allowed[] string",
    "serverName.known[] string",
    "accessLog.remoteAddressHeaders[] string",
    "accessLog.remotePortHeaders[] string",
    "accessLog.content[].pathPrefix string",
    "accessLog.content[].maxSize long",
    "accessLog.content[].sampleRate double",
    "compliance.httpViolations[] string"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Integer listenPort = null;
    private String name = null;
    private Integer headerCacheSize = null;
    private Integer outputBufferSize = null;
    private Integer requestHeaderSize = null;
    private Integer responseHeaderSize = null;
    private Integer acceptQueueSize = null;
    private Long maxContentSize = null;
    private String maxContentSizeErrorMessageTemplate = null;
    private Boolean reuseAddress = null;
    private Double idleTimeout = null;
    private Double shutdownIdleTimeout = null;
    private Boolean tcpKeepAliveEnabled = null;
    private Boolean tcpNoDelay = null;
    public Throttling.Builder throttling = new Throttling.Builder();
    private Boolean implicitTlsEnabled = null;
    public Ssl.Builder ssl = new Ssl.Builder();
    public TlsClientAuthEnforcer.Builder tlsClientAuthEnforcer = new TlsClientAuthEnforcer.Builder();
    public HealthCheckProxy.Builder healthCheckProxy = new HealthCheckProxy.Builder();
    public ProxyProtocol.Builder proxyProtocol = new ProxyProtocol.Builder();
    private Integer maxRequestsPerConnection = null;
    private Double maxConnectionLife = null;
    private Boolean http2Enabled = null;
    public Http2.Builder http2 = new Http2.Builder();
    public ServerName.Builder serverName = new ServerName.Builder();
    public AccessLog.Builder accessLog = new AccessLog.Builder();
    public Compliance.Builder compliance = new Compliance.Builder();

    public Builder() { }

    public Builder(ConnectorConfig config) {
      listenPort(config.listenPort());
      name(config.name());
      headerCacheSize(config.headerCacheSize());
      outputBufferSize(config.outputBufferSize());
      requestHeaderSize(config.requestHeaderSize());
      responseHeaderSize(config.responseHeaderSize());
      acceptQueueSize(config.acceptQueueSize());
      maxContentSize(config.maxContentSize());
      maxContentSizeErrorMessageTemplate(config.maxContentSizeErrorMessageTemplate());
      reuseAddress(config.reuseAddress());
      idleTimeout(config.idleTimeout());
      shutdownIdleTimeout(config.shutdownIdleTimeout());
      tcpKeepAliveEnabled(config.tcpKeepAliveEnabled());
      tcpNoDelay(config.tcpNoDelay());
      throttling(new Throttling.Builder(config.throttling()));
      implicitTlsEnabled(config.implicitTlsEnabled());
      ssl(new Ssl.Builder(config.ssl()));
      tlsClientAuthEnforcer(new TlsClientAuthEnforcer.Builder(config.tlsClientAuthEnforcer()));
      healthCheckProxy(new HealthCheckProxy.Builder(config.healthCheckProxy()));
      proxyProtocol(new ProxyProtocol.Builder(config.proxyProtocol()));
      maxRequestsPerConnection(config.maxRequestsPerConnection());
      maxConnectionLife(config.maxConnectionLife());
      http2Enabled(config.http2Enabled());
      http2(new Http2.Builder(config.http2()));
      serverName(new ServerName.Builder(config.serverName()));
      accessLog(new AccessLog.Builder(config.accessLog()));
      compliance(new Compliance.Builder(config.compliance()));
    }

    private Builder override(Builder __superior) {
      if (__superior.listenPort != null)
        listenPort(__superior.listenPort);
      if (__superior.name != null)
        name(__superior.name);
      if (__superior.headerCacheSize != null)
        headerCacheSize(__superior.headerCacheSize);
      if (__superior.outputBufferSize != null)
        outputBufferSize(__superior.outputBufferSize);
      if (__superior.requestHeaderSize != null)
        requestHeaderSize(__superior.requestHeaderSize);
      if (__superior.responseHeaderSize != null)
        responseHeaderSize(__superior.responseHeaderSize);
      if (__superior.acceptQueueSize != null)
        acceptQueueSize(__superior.acceptQueueSize);
      if (__superior.maxContentSize != null)
        maxContentSize(__superior.maxContentSize);
      if (__superior.maxContentSizeErrorMessageTemplate != null)
        maxContentSizeErrorMessageTemplate(__superior.maxContentSizeErrorMessageTemplate);
      if (__superior.reuseAddress != null)
        reuseAddress(__superior.reuseAddress);
      if (__superior.idleTimeout != null)
        idleTimeout(__superior.idleTimeout);
      if (__superior.shutdownIdleTimeout != null)
        shutdownIdleTimeout(__superior.shutdownIdleTimeout);
      if (__superior.tcpKeepAliveEnabled != null)
        tcpKeepAliveEnabled(__superior.tcpKeepAliveEnabled);
      if (__superior.tcpNoDelay != null)
        tcpNoDelay(__superior.tcpNoDelay);
      throttling(throttling.override(__superior.throttling));
      if (__superior.implicitTlsEnabled != null)
        implicitTlsEnabled(__superior.implicitTlsEnabled);
      ssl(ssl.override(__superior.ssl));
      tlsClientAuthEnforcer(tlsClientAuthEnforcer.override(__superior.tlsClientAuthEnforcer));
      healthCheckProxy(healthCheckProxy.override(__superior.healthCheckProxy));
      proxyProtocol(proxyProtocol.override(__superior.proxyProtocol));
      if (__superior.maxRequestsPerConnection != null)
        maxRequestsPerConnection(__superior.maxRequestsPerConnection);
      if (__superior.maxConnectionLife != null)
        maxConnectionLife(__superior.maxConnectionLife);
      if (__superior.http2Enabled != null)
        http2Enabled(__superior.http2Enabled);
      http2(http2.override(__superior.http2));
      serverName(serverName.override(__superior.serverName));
      accessLog(accessLog.override(__superior.accessLog));
      compliance(compliance.override(__superior.compliance));
      return this;
    }

    public Builder listenPort(int __value) {
      listenPort = __value;
      return this;
    }

    private Builder listenPort(String __value) {
      return listenPort(Integer.valueOf(__value));
    }

    public Builder name(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      name = __value;
      return this;
    }


    public Builder headerCacheSize(int __value) {
      headerCacheSize = __value;
      return this;
    }

    private Builder headerCacheSize(String __value) {
      return headerCacheSize(Integer.valueOf(__value));
    }

    public Builder outputBufferSize(int __value) {
      outputBufferSize = __value;
      return this;
    }

    private Builder outputBufferSize(String __value) {
      return outputBufferSize(Integer.valueOf(__value));
    }

    public Builder requestHeaderSize(int __value) {
      requestHeaderSize = __value;
      return this;
    }

    private Builder requestHeaderSize(String __value) {
      return requestHeaderSize(Integer.valueOf(__value));
    }

    public Builder responseHeaderSize(int __value) {
      responseHeaderSize = __value;
      return this;
    }

    private Builder responseHeaderSize(String __value) {
      return responseHeaderSize(Integer.valueOf(__value));
    }

    public Builder acceptQueueSize(int __value) {
      acceptQueueSize = __value;
      return this;
    }

    private Builder acceptQueueSize(String __value) {
      return acceptQueueSize(Integer.valueOf(__value));
    }

    public Builder maxContentSize(long __value) {
      maxContentSize = __value;
      return this;
    }

    private Builder maxContentSize(String __value) {
      return maxContentSize(Long.valueOf(__value));
    }

    public Builder maxContentSizeErrorMessageTemplate(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      maxContentSizeErrorMessageTemplate = __value;
      return this;
    }


    public Builder reuseAddress(boolean __value) {
      reuseAddress = __value;
      return this;
    }

    private Builder reuseAddress(String __value) {
      return reuseAddress(Boolean.valueOf(__value));
    }

    public Builder idleTimeout(double __value) {
      idleTimeout = __value;
      return this;
    }

    private Builder idleTimeout(String __value) {
      return idleTimeout(Double.valueOf(__value));
    }

    public Builder shutdownIdleTimeout(double __value) {
      shutdownIdleTimeout = __value;
      return this;
    }

    private Builder shutdownIdleTimeout(String __value) {
      return shutdownIdleTimeout(Double.valueOf(__value));
    }

    public Builder tcpKeepAliveEnabled(boolean __value) {
      tcpKeepAliveEnabled = __value;
      return this;
    }

    private Builder tcpKeepAliveEnabled(String __value) {
      return tcpKeepAliveEnabled(Boolean.valueOf(__value));
    }

    public Builder tcpNoDelay(boolean __value) {
      tcpNoDelay = __value;
      return this;
    }

    private Builder tcpNoDelay(String __value) {
      return tcpNoDelay(Boolean.valueOf(__value));
    }

    public Builder throttling(Throttling.Builder __builder) {
      throttling = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder throttling(java.util.function.Consumer<Throttling.Builder> __func) {
      Throttling.Builder __inner = new Throttling.Builder();
      __func.accept(__inner);
      throttling = __inner;
      return this;
    }

    public Builder implicitTlsEnabled(boolean __value) {
      implicitTlsEnabled = __value;
      return this;
    }

    private Builder implicitTlsEnabled(String __value) {
      return implicitTlsEnabled(Boolean.valueOf(__value));
    }

    public Builder ssl(Ssl.Builder __builder) {
      ssl = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder ssl(java.util.function.Consumer<Ssl.Builder> __func) {
      Ssl.Builder __inner = new Ssl.Builder();
      __func.accept(__inner);
      ssl = __inner;
      return this;
    }

    public Builder tlsClientAuthEnforcer(TlsClientAuthEnforcer.Builder __builder) {
      tlsClientAuthEnforcer = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder tlsClientAuthEnforcer(java.util.function.Consumer<TlsClientAuthEnforcer.Builder> __func) {
      TlsClientAuthEnforcer.Builder __inner = new TlsClientAuthEnforcer.Builder();
      __func.accept(__inner);
      tlsClientAuthEnforcer = __inner;
      return this;
    }

    public Builder healthCheckProxy(HealthCheckProxy.Builder __builder) {
      healthCheckProxy = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder healthCheckProxy(java.util.function.Consumer<HealthCheckProxy.Builder> __func) {
      HealthCheckProxy.Builder __inner = new HealthCheckProxy.Builder();
      __func.accept(__inner);
      healthCheckProxy = __inner;
      return this;
    }

    public Builder proxyProtocol(ProxyProtocol.Builder __builder) {
      proxyProtocol = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder proxyProtocol(java.util.function.Consumer<ProxyProtocol.Builder> __func) {
      ProxyProtocol.Builder __inner = new ProxyProtocol.Builder();
      __func.accept(__inner);
      proxyProtocol = __inner;
      return this;
    }

    public Builder maxRequestsPerConnection(int __value) {
      maxRequestsPerConnection = __value;
      return this;
    }

    private Builder maxRequestsPerConnection(String __value) {
      return maxRequestsPerConnection(Integer.valueOf(__value));
    }

    public Builder maxConnectionLife(double __value) {
      maxConnectionLife = __value;
      return this;
    }

    private Builder maxConnectionLife(String __value) {
      return maxConnectionLife(Double.valueOf(__value));
    }

    public Builder http2Enabled(boolean __value) {
      http2Enabled = __value;
      return this;
    }

    private Builder http2Enabled(String __value) {
      return http2Enabled(Boolean.valueOf(__value));
    }

    public Builder http2(Http2.Builder __builder) {
      http2 = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder http2(java.util.function.Consumer<Http2.Builder> __func) {
      Http2.Builder __inner = new Http2.Builder();
      __func.accept(__inner);
      http2 = __inner;
      return this;
    }

    public Builder serverName(ServerName.Builder __builder) {
      serverName = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder serverName(java.util.function.Consumer<ServerName.Builder> __func) {
      ServerName.Builder __inner = new ServerName.Builder();
      __func.accept(__inner);
      serverName = __inner;
      return this;
    }

    public Builder accessLog(AccessLog.Builder __builder) {
      accessLog = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder accessLog(java.util.function.Consumer<AccessLog.Builder> __func) {
      AccessLog.Builder __inner = new AccessLog.Builder();
      __func.accept(__inner);
      accessLog = __inner;
      return this;
    }

    public Builder compliance(Compliance.Builder __builder) {
      compliance = __builder;
      return this;
    }
    /**
     * Make a new builder and run the supplied function on it before adding it to the list
     * @param __func lambda that modifies the given builder
     * @return this builder
     */
    public Builder compliance(java.util.function.Consumer<Compliance.Builder> __func) {
      Compliance.Builder __inner = new Compliance.Builder();
      __func.accept(__inner);
      compliance = __inner;
      return this;
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public ConnectorConfig build() {
      return new ConnectorConfig(this);
    }

  }

  // The TCP port to listen to for this connector.
  private final IntegerNode listenPort;
  // The connector name
  private final StringNode name;
  // The header field cache size.
  private final IntegerNode headerCacheSize;
  // The size of the buffer into which response content is aggregated before being sent to the client.
  private final IntegerNode outputBufferSize;
  // The maximum size of a request header.
  private final IntegerNode requestHeaderSize;
  // The maximum size of a response header.
  private final IntegerNode responseHeaderSize;
  // The accept queue size (also known as accept backlog).
  private final IntegerNode acceptQueueSize;
  // Max content size allowed for requests. Set to -1 to disable. Set to 0 for auto (50% of heap size, max 2GB).
  private final LongNode maxContentSize;
  private final StringNode maxContentSizeErrorMessageTemplate;
  // Whether the server socket reuses addresses.
  private final BooleanNode reuseAddress;
  // The maximum idle time for a connection, which roughly translates to the Socket.setSoTimeout(int).
  private final DoubleNode idleTimeout;
  // The idle timeout that takes effect during graceful shutdown of Jetty
  private final DoubleNode shutdownIdleTimeout;
  // TODO Vespa 9 Remove
  // Has no effect since Jetty 11 upgrade
  private final BooleanNode tcpKeepAliveEnabled;
  // Enable/disable TCP_NODELAY (disable/enable Nagle's algorithm).
  private final BooleanNode tcpNoDelay;
  private final Throttling throttling;
  // Whether to enable TLS on connector when Vespa is configured with TLS.
  // The connector will implicitly enable TLS if set to 'true' and Vespa TLS is enabled.
  private final BooleanNode implicitTlsEnabled;
  private final Ssl ssl;
  private final TlsClientAuthEnforcer tlsClientAuthEnforcer;
  private final HealthCheckProxy healthCheckProxy;
  private final ProxyProtocol proxyProtocol;
  // Maximum number of request per connection before server marks connections as non-persistent. Set to '0' to disable.
  private final IntegerNode maxRequestsPerConnection;
  // Maximum number of seconds a connection can live before it's marked as non-persistent. Set to '0' to disable.
  private final DoubleNode maxConnectionLife;
  // Enable HTTP/2 (in addition to HTTP/1.1 using ALPN)
  private final BooleanNode http2Enabled;
  private final Http2 http2;
  private final ServerName serverName;
  private final AccessLog accessLog;
  private final Compliance compliance;

  public ConnectorConfig(Builder builder) {
    this(builder, true);
  }

  private ConnectorConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "connector must be initialized: " + builder.__uninitialized);

    listenPort = (builder.listenPort == null) ?
        new IntegerNode(0) : new IntegerNode(builder.listenPort);
    name = (builder.name == null) ?
        new StringNode("default") : new StringNode(builder.name);
    headerCacheSize = (builder.headerCacheSize == null) ?
        new IntegerNode(512) : new IntegerNode(builder.headerCacheSize);
    outputBufferSize = (builder.outputBufferSize == null) ?
        new IntegerNode(65536) : new IntegerNode(builder.outputBufferSize);
    requestHeaderSize = (builder.requestHeaderSize == null) ?
        new IntegerNode(65536) : new IntegerNode(builder.requestHeaderSize);
    responseHeaderSize = (builder.responseHeaderSize == null) ?
        new IntegerNode(65536) : new IntegerNode(builder.responseHeaderSize);
    acceptQueueSize = (builder.acceptQueueSize == null) ?
        new IntegerNode(0) : new IntegerNode(builder.acceptQueueSize);
    maxContentSize = (builder.maxContentSize == null) ?
        new LongNode(-1L) : new LongNode(builder.maxContentSize);
    maxContentSizeErrorMessageTemplate = (builder.maxContentSizeErrorMessageTemplate == null) ?
        new StringNode("Request content length %1$d exceeds limit of %2$d bytes") : new StringNode(builder.maxContentSizeErrorMessageTemplate);
    reuseAddress = (builder.reuseAddress == null) ?
        new BooleanNode(true) : new BooleanNode(builder.reuseAddress);
    idleTimeout = (builder.idleTimeout == null) ?
        new DoubleNode(180.0D) : new DoubleNode(builder.idleTimeout);
    shutdownIdleTimeout = (builder.shutdownIdleTimeout == null) ?
        new DoubleNode(1.0D) : new DoubleNode(builder.shutdownIdleTimeout);
    tcpKeepAliveEnabled = (builder.tcpKeepAliveEnabled == null) ?
        new BooleanNode(false) : new BooleanNode(builder.tcpKeepAliveEnabled);
    tcpNoDelay = (builder.tcpNoDelay == null) ?
        new BooleanNode(true) : new BooleanNode(builder.tcpNoDelay);
    throttling = new Throttling(builder.throttling, throwIfUninitialized);
    implicitTlsEnabled = (builder.implicitTlsEnabled == null) ?
        new BooleanNode(true) : new BooleanNode(builder.implicitTlsEnabled);
    ssl = new Ssl(builder.ssl, throwIfUninitialized);
    tlsClientAuthEnforcer = new TlsClientAuthEnforcer(builder.tlsClientAuthEnforcer, throwIfUninitialized);
    healthCheckProxy = new HealthCheckProxy(builder.healthCheckProxy, throwIfUninitialized);
    proxyProtocol = new ProxyProtocol(builder.proxyProtocol, throwIfUninitialized);
    maxRequestsPerConnection = (builder.maxRequestsPerConnection == null) ?
        new IntegerNode(0) : new IntegerNode(builder.maxRequestsPerConnection);
    maxConnectionLife = (builder.maxConnectionLife == null) ?
        new DoubleNode(0.0D) : new DoubleNode(builder.maxConnectionLife);
    http2Enabled = (builder.http2Enabled == null) ?
        new BooleanNode(true) : new BooleanNode(builder.http2Enabled);
    http2 = new Http2(builder.http2, throwIfUninitialized);
    serverName = new ServerName(builder.serverName, throwIfUninitialized);
    accessLog = new AccessLog(builder.accessLog, throwIfUninitialized);
    compliance = new Compliance(builder.compliance, throwIfUninitialized);
  }

  /**
   * @return connector.listenPort
   */
  public int listenPort() {
    return listenPort.value();
  }

  /**
   * @return connector.name
   */
  public String name() {
    return name.value();
  }

  /**
   * @return connector.headerCacheSize
   */
  public int headerCacheSize() {
    return headerCacheSize.value();
  }

  /**
   * @return connector.outputBufferSize
   */
  public int outputBufferSize() {
    return outputBufferSize.value();
  }

  /**
   * @return connector.requestHeaderSize
   */
  public int requestHeaderSize() {
    return requestHeaderSize.value();
  }

  /**
   * @return connector.responseHeaderSize
   */
  public int responseHeaderSize() {
    return responseHeaderSize.value();
  }

  /**
   * @return connector.acceptQueueSize
   */
  public int acceptQueueSize() {
    return acceptQueueSize.value();
  }

  /**
   * @return connector.maxContentSize
   */
  public long maxContentSize() {
    return maxContentSize.value();
  }

  /**
   * @return connector.maxContentSizeErrorMessageTemplate
   */
  public String maxContentSizeErrorMessageTemplate() {
    return maxContentSizeErrorMessageTemplate.value();
  }

  /**
   * @return connector.reuseAddress
   */
  public boolean reuseAddress() {
    return reuseAddress.value();
  }

  /**
   * @return connector.idleTimeout
   */
  public double idleTimeout() {
    return idleTimeout.value();
  }

  /**
   * @return connector.shutdownIdleTimeout
   */
  public double shutdownIdleTimeout() {
    return shutdownIdleTimeout.value();
  }

  /**
   * @return connector.tcpKeepAliveEnabled
   */
  public boolean tcpKeepAliveEnabled() {
    return tcpKeepAliveEnabled.value();
  }

  /**
   * @return connector.tcpNoDelay
   */
  public boolean tcpNoDelay() {
    return tcpNoDelay.value();
  }

  /**
   * @return connector.throttling
   */
  public Throttling throttling() {
    return throttling;
  }

  /**
   * @return connector.implicitTlsEnabled
   */
  public boolean implicitTlsEnabled() {
    return implicitTlsEnabled.value();
  }

  /**
   * @return connector.ssl
   */
  public Ssl ssl() {
    return ssl;
  }

  /**
   * @return connector.tlsClientAuthEnforcer
   */
  public TlsClientAuthEnforcer tlsClientAuthEnforcer() {
    return tlsClientAuthEnforcer;
  }

  /**
   * @return connector.healthCheckProxy
   */
  public HealthCheckProxy healthCheckProxy() {
    return healthCheckProxy;
  }

  /**
   * @return connector.proxyProtocol
   */
  public ProxyProtocol proxyProtocol() {
    return proxyProtocol;
  }

  /**
   * @return connector.maxRequestsPerConnection
   */
  public int maxRequestsPerConnection() {
    return maxRequestsPerConnection.value();
  }

  /**
   * @return connector.maxConnectionLife
   */
  public double maxConnectionLife() {
    return maxConnectionLife.value();
  }

  /**
   * @return connector.http2Enabled
   */
  public boolean http2Enabled() {
    return http2Enabled.value();
  }

  /**
   * @return connector.http2
   */
  public Http2 http2() {
    return http2;
  }

  /**
   * @return connector.serverName
   */
  public ServerName serverName() {
    return serverName;
  }

  /**
   * @return connector.accessLog
   */
  public AccessLog accessLog() {
    return accessLog;
  }

  /**
   * @return connector.compliance
   */
  public Compliance compliance() {
    return compliance;
  }

  private ChangesRequiringRestart getChangesRequiringRestart(ConnectorConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("connector");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }

  /**
   * This class represents connector.throttling
   */
  public final static class Throttling extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Boolean enabled = null;
      private Integer maxConnections = null;
      private Double maxHeapUtilization = null;
      private Integer maxAcceptRate = null;
      private Double idleTimeout = null;

      public Builder() { }

      public Builder(Throttling config) {
        enabled(config.enabled());
        maxConnections(config.maxConnections());
        maxHeapUtilization(config.maxHeapUtilization());
        maxAcceptRate(config.maxAcceptRate());
        idleTimeout(config.idleTimeout());
      }

      private Builder override(Builder __superior) {
        if (__superior.enabled != null)
          enabled(__superior.enabled);
        if (__superior.maxConnections != null)
          maxConnections(__superior.maxConnections);
        if (__superior.maxHeapUtilization != null)
          maxHeapUtilization(__superior.maxHeapUtilization);
        if (__superior.maxAcceptRate != null)
          maxAcceptRate(__superior.maxAcceptRate);
        if (__superior.idleTimeout != null)
          idleTimeout(__superior.idleTimeout);
        return this;
      }

      public Builder enabled(boolean __value) {
        enabled = __value;
        return this;
      }

      private Builder enabled(String __value) {
        return enabled(Boolean.valueOf(__value));
      }

      public Builder maxConnections(int __value) {
        maxConnections = __value;
        return this;
      }

      private Builder maxConnections(String __value) {
        return maxConnections(Integer.valueOf(__value));
      }

      public Builder maxHeapUtilization(double __value) {
        maxHeapUtilization = __value;
        return this;
      }

      private Builder maxHeapUtilization(String __value) {
        return maxHeapUtilization(Double.valueOf(__value));
      }

      public Builder maxAcceptRate(int __value) {
        maxAcceptRate = __value;
        return this;
      }

      private Builder maxAcceptRate(String __value) {
        return maxAcceptRate(Integer.valueOf(__value));
      }

      public Builder idleTimeout(double __value) {
        idleTimeout = __value;
        return this;
      }

      private Builder idleTimeout(String __value) {
        return idleTimeout(Double.valueOf(__value));
      }

      public Throttling build() {
        return new Throttling(this);
      }

    }

    // Whether to enable connection throttling. New connections will be dropped when a threshold is exceeded.
    private final BooleanNode enabled;
    // Max number of connections.
    private final IntegerNode maxConnections;
    // Max memory utilization as a value between 0 and 1.
    private final DoubleNode maxHeapUtilization;
    // Max connection accept rate per second.
    private final IntegerNode maxAcceptRate;
    // Idle timeout in seconds applied to endpoints when a threshold is exceeded.
    private final DoubleNode idleTimeout;

    public Throttling(Builder builder) {
      this(builder, true);
    }

    private Throttling(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "connector.throttling must be initialized: " + builder.__uninitialized);

      enabled = (builder.enabled == null) ?
          new BooleanNode(false) : new BooleanNode(builder.enabled);
      maxConnections = (builder.maxConnections == null) ?
          new IntegerNode(-1) : new IntegerNode(builder.maxConnections);
      maxHeapUtilization = (builder.maxHeapUtilization == null) ?
          new DoubleNode(-1.0D) : new DoubleNode(builder.maxHeapUtilization);
      maxAcceptRate = (builder.maxAcceptRate == null) ?
          new IntegerNode(-1) : new IntegerNode(builder.maxAcceptRate);
      idleTimeout = (builder.idleTimeout == null) ?
          new DoubleNode(-1.0D) : new DoubleNode(builder.idleTimeout);
    }

    /**
     * @return connector.throttling.enabled
     */
    public boolean enabled() {
      return enabled.value();
    }

    /**
     * @return connector.throttling.maxConnections
     */
    public int maxConnections() {
      return maxConnections.value();
    }

    /**
     * @return connector.throttling.maxHeapUtilization
     */
    public double maxHeapUtilization() {
      return maxHeapUtilization.value();
    }

    /**
     * @return connector.throttling.maxAcceptRate
     */
    public int maxAcceptRate() {
      return maxAcceptRate.value();
    }

    /**
     * @return connector.throttling.idleTimeout
     */
    public double idleTimeout() {
      return idleTimeout.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Throttling newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("throttling");
      return changes;
    }
  }

  /**
   * This class represents connector.ssl
   */
  public final static class Ssl extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Boolean enabled = null;
      private String privateKeyFile = null;
      private String privateKey = null;
      private String certificateFile = null;
      private String certificate = null;
      private String caCertificateFile = null;
      private String caCertificate = null;
      private ClientAuth.Enum clientAuth = null;
      public List<String> enabledCipherSuites = new ArrayList<>();
      public List<String> enabledProtocols = new ArrayList<>();

      public Builder() { }

      public Builder(Ssl config) {
        enabled(config.enabled());
        privateKeyFile(config.privateKeyFile());
        privateKey(config.privateKey());
        certificateFile(config.certificateFile());
        certificate(config.certificate());
        caCertificateFile(config.caCertificateFile());
        caCertificate(config.caCertificate());
        clientAuth(config.clientAuth());
        enabledCipherSuites(config.enabledCipherSuites());
        enabledProtocols(config.enabledProtocols());
      }

      private Builder override(Builder __superior) {
        if (__superior.enabled != null)
          enabled(__superior.enabled);
        if (__superior.privateKeyFile != null)
          privateKeyFile(__superior.privateKeyFile);
        if (__superior.privateKey != null)
          privateKey(__superior.privateKey);
        if (__superior.certificateFile != null)
          certificateFile(__superior.certificateFile);
        if (__superior.certificate != null)
          certificate(__superior.certificate);
        if (__superior.caCertificateFile != null)
          caCertificateFile(__superior.caCertificateFile);
        if (__superior.caCertificate != null)
          caCertificate(__superior.caCertificate);
        if (__superior.clientAuth != null)
          clientAuth(__superior.clientAuth);
        if (!__superior.enabledCipherSuites.isEmpty())
          enabledCipherSuites.addAll(__superior.enabledCipherSuites);
        if (!__superior.enabledProtocols.isEmpty())
          enabledProtocols.addAll(__superior.enabledProtocols);
        return this;
      }

      public Builder enabled(boolean __value) {
        enabled = __value;
        return this;
      }

      private Builder enabled(String __value) {
        return enabled(Boolean.valueOf(__value));
      }

      public Builder privateKeyFile(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        privateKeyFile = __value;
        return this;
      }


      public Builder privateKey(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        privateKey = __value;
        return this;
      }


      public Builder certificateFile(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        certificateFile = __value;
        return this;
      }


      public Builder certificate(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        certificate = __value;
        return this;
      }


      public Builder caCertificateFile(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        caCertificateFile = __value;
        return this;
      }


      public Builder caCertificate(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        caCertificate = __value;
        return this;
      }


      public Builder clientAuth(ClientAuth.Enum __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        clientAuth = __value;
        return this;
      }

      private Builder clientAuth(String __value) {
        return clientAuth(ClientAuth.Enum.valueOf(__value));
      }

      public Builder enabledCipherSuites(String __value) {
        enabledCipherSuites.add(__value);
        return this;
      }

      public Builder enabledCipherSuites(Collection<String> __values) {
        enabledCipherSuites.addAll(__values);
        return this;
      }

      public Builder enabledProtocols(String __value) {
        enabledProtocols.add(__value);
        return this;
      }

      public Builder enabledProtocols(Collection<String> __values) {
        enabledProtocols.addAll(__values);
        return this;
      }

      public Ssl build() {
        return new Ssl(this);
      }

    }

    // Whether to enable SSL for this connector.
    private final BooleanNode enabled;
    // File with private key in PEM format. Specify either this or privateKey, but not both
    private final StringNode privateKeyFile;
    // Private key in PEM format. Specify either this or privateKeyFile, but not both
    private final StringNode privateKey;
    // File with certificate in PEM format. Specify either this or certificate, but not both
    private final StringNode certificateFile;
    // Certificate in PEM format. Specify either this or certificateFile, but not both
    private final StringNode certificate;
    // with trusted CA certificates in PEM format. Used to verify clients
    // - this is the name of a file on the local container file system
    // - only one of caCertificateFile and caCertificate
    private final StringNode caCertificateFile;
    // with trusted CA certificates in PEM format. Used to verify clients
    // - this is the actual certificates instead of a pointer to the file
    // - only one of caCertificateFile and caCertificate
    private final StringNode caCertificate;
    // Client authentication mode. See SSLEngine.getNeedClientAuth()/getWantClientAuth() for details.
    private final ClientAuth clientAuth;
    // List of enabled cipher suites. JDisc will use Vespa default if empty.
    private final LeafNodeVector<String, StringNode> enabledCipherSuites;
    // List of enabled TLS protocol versions. JDisc will use Vespa default if empty.
    private final LeafNodeVector<String, StringNode> enabledProtocols;

    public Ssl(Builder builder) {
      this(builder, true);
    }

    private Ssl(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "connector.ssl must be initialized: " + builder.__uninitialized);

      enabled = (builder.enabled == null) ?
          new BooleanNode(false) : new BooleanNode(builder.enabled);
      privateKeyFile = (builder.privateKeyFile == null) ?
          new StringNode("") : new StringNode(builder.privateKeyFile);
      privateKey = (builder.privateKey == null) ?
          new StringNode("") : new StringNode(builder.privateKey);
      certificateFile = (builder.certificateFile == null) ?
          new StringNode("") : new StringNode(builder.certificateFile);
      certificate = (builder.certificate == null) ?
          new StringNode("") : new StringNode(builder.certificate);
      caCertificateFile = (builder.caCertificateFile == null) ?
          new StringNode("") : new StringNode(builder.caCertificateFile);
      caCertificate = (builder.caCertificate == null) ?
          new StringNode("") : new StringNode(builder.caCertificate);
      clientAuth = (builder.clientAuth == null) ?
          new ClientAuth(ClientAuth.DISABLED) : new ClientAuth(builder.clientAuth);
      enabledCipherSuites = new LeafNodeVector<>(builder.enabledCipherSuites, new StringNode());
      enabledProtocols = new LeafNodeVector<>(builder.enabledProtocols, new StringNode());
    }

    /**
     * @return connector.ssl.enabled
     */
    public boolean enabled() {
      return enabled.value();
    }

    /**
     * @return connector.ssl.privateKeyFile
     */
    public String privateKeyFile() {
      return privateKeyFile.value();
    }

    /**
     * @return connector.ssl.privateKey
     */
    public String privateKey() {
      return privateKey.value();
    }

    /**
     * @return connector.ssl.certificateFile
     */
    public String certificateFile() {
      return certificateFile.value();
    }

    /**
     * @return connector.ssl.certificate
     */
    public String certificate() {
      return certificate.value();
    }

    /**
     * @return connector.ssl.caCertificateFile
     */
    public String caCertificateFile() {
      return caCertificateFile.value();
    }

    /**
     * @return connector.ssl.caCertificate
     */
    public String caCertificate() {
      return caCertificate.value();
    }

    /**
     * @return connector.ssl.clientAuth
     */
    public ClientAuth.Enum clientAuth() {
      return clientAuth.value();
    }

    /**
     * @return connector.ssl.enabledCipherSuites[]
     */
    public List<String> enabledCipherSuites() {
      return enabledCipherSuites.asList();
    }

    /**
     * @param i the index of the value to return
     * @return connector.ssl.enabledCipherSuites[]
     */
    public String enabledCipherSuites(int i) {
      return enabledCipherSuites.get(i).value();
    }

    /**
     * @return connector.ssl.enabledProtocols[]
     */
    public List<String> enabledProtocols() {
      return enabledProtocols.asList();
    }

    /**
     * @param i the index of the value to return
     * @return connector.ssl.enabledProtocols[]
     */
    public String enabledProtocols(int i) {
      return enabledProtocols.get(i).value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Ssl newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("ssl");
      return changes;
    }

    /**
     * This class represents connector.ssl.clientAuth
     * 
     * Client authentication mode. See SSLEngine.getNeedClientAuth()/getWantClientAuth() for details.
     */
    public final static class ClientAuth extends EnumNode<ClientAuth.Enum> {

      public ClientAuth(){
        this.value = null;
      }

      public ClientAuth(Enum enumValue) {
        super(enumValue != null);
        this.value = enumValue;
      }

      public enum Enum {DISABLED, WANT_AUTH, NEED_AUTH}
      public final static Enum DISABLED = Enum.DISABLED;
      public final static Enum WANT_AUTH = Enum.WANT_AUTH;
      public final static Enum NEED_AUTH = Enum.NEED_AUTH;

      @Override
      protected boolean doSetValue(String name) {
        try {
          value = Enum.valueOf(name);
          return true;
        } catch (IllegalArgumentException e) {
        }
        return false;
      }
    }
  }

  /**
   * This class represents connector.tlsClientAuthEnforcer
   */
  public final static class TlsClientAuthEnforcer extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Boolean enable = null;
      public List<String> pathWhitelist = new ArrayList<>();

      public Builder() { }

      public Builder(TlsClientAuthEnforcer config) {
        enable(config.enable());
        pathWhitelist(config.pathWhitelist());
      }

      private Builder override(Builder __superior) {
        if (__superior.enable != null)
          enable(__superior.enable);
        if (!__superior.pathWhitelist.isEmpty())
          pathWhitelist.addAll(__superior.pathWhitelist);
        return this;
      }

      public Builder enable(boolean __value) {
        enable = __value;
        return this;
      }

      private Builder enable(String __value) {
        return enable(Boolean.valueOf(__value));
      }

      public Builder pathWhitelist(String __value) {
        pathWhitelist.add(__value);
        return this;
      }

      public Builder pathWhitelist(Collection<String> __values) {
        pathWhitelist.addAll(__values);
        return this;
      }

      public TlsClientAuthEnforcer build() {
        return new TlsClientAuthEnforcer(this);
      }

    }

    // Enforce TLS client authentication for https requests at the http layer.
    // Intended to be used with connectors with optional client authentication enabled.
    // 401 status code is returned for requests from non-authenticated clients.
    private final BooleanNode enable;
    // Paths where client authentication should not be enforced. To be used in combination with WANT_AUTH. Typically used for health checks.
    private final LeafNodeVector<String, StringNode> pathWhitelist;

    public TlsClientAuthEnforcer(Builder builder) {
      this(builder, true);
    }

    private TlsClientAuthEnforcer(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "connector.tlsClientAuthEnforcer must be initialized: " + builder.__uninitialized);

      enable = (builder.enable == null) ?
          new BooleanNode(false) : new BooleanNode(builder.enable);
      pathWhitelist = new LeafNodeVector<>(builder.pathWhitelist, new StringNode());
    }

    /**
     * @return connector.tlsClientAuthEnforcer.enable
     */
    public boolean enable() {
      return enable.value();
    }

    /**
     * @return connector.tlsClientAuthEnforcer.pathWhitelist[]
     */
    public List<String> pathWhitelist() {
      return pathWhitelist.asList();
    }

    /**
     * @param i the index of the value to return
     * @return connector.tlsClientAuthEnforcer.pathWhitelist[]
     */
    public String pathWhitelist(int i) {
      return pathWhitelist.get(i).value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(TlsClientAuthEnforcer newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("tlsClientAuthEnforcer");
      return changes;
    }
  }

  /**
   * This class represents connector.healthCheckProxy
   */
  public final static class HealthCheckProxy extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Boolean enable = null;
      private Integer port = null;
      private Double clientTimeout = null;
      private Double handlerTimeout = null;
      private Double cacheExpiry = null;

      public Builder() { }

      public Builder(HealthCheckProxy config) {
        enable(config.enable());
        port(config.port());
        clientTimeout(config.clientTimeout());
        handlerTimeout(config.handlerTimeout());
        cacheExpiry(config.cacheExpiry());
      }

      private Builder override(Builder __superior) {
        if (__superior.enable != null)
          enable(__superior.enable);
        if (__superior.port != null)
          port(__superior.port);
        if (__superior.clientTimeout != null)
          clientTimeout(__superior.clientTimeout);
        if (__superior.handlerTimeout != null)
          handlerTimeout(__superior.handlerTimeout);
        if (__superior.cacheExpiry != null)
          cacheExpiry(__superior.cacheExpiry);
        return this;
      }

      public Builder enable(boolean __value) {
        enable = __value;
        return this;
      }

      private Builder enable(String __value) {
        return enable(Boolean.valueOf(__value));
      }

      public Builder port(int __value) {
        port = __value;
        return this;
      }

      private Builder port(String __value) {
        return port(Integer.valueOf(__value));
      }

      public Builder clientTimeout(double __value) {
        clientTimeout = __value;
        return this;
      }

      private Builder clientTimeout(String __value) {
        return clientTimeout(Double.valueOf(__value));
      }

      public Builder handlerTimeout(double __value) {
        handlerTimeout = __value;
        return this;
      }

      private Builder handlerTimeout(String __value) {
        return handlerTimeout(Double.valueOf(__value));
      }

      public Builder cacheExpiry(double __value) {
        cacheExpiry = __value;
        return this;
      }

      private Builder cacheExpiry(String __value) {
        return cacheExpiry(Double.valueOf(__value));
      }

      public HealthCheckProxy build() {
        return new HealthCheckProxy(this);
      }

    }

    // Use connector only for proxying '/status.html' health checks. Any ssl configuration will be ignored if this option is enabled.
    private final BooleanNode enable;
    // Which port to proxy
    private final IntegerNode port;
    // Low-level timeout for proxy client (socket connect, socket read, connection pool).
    private final DoubleNode clientTimeout;
    // Servlet async request timeout. Must be larger than 'clientTimeout' to cover cost of queueing and response handling.
    private final DoubleNode handlerTimeout;
    // Expiry for cached health response
    private final DoubleNode cacheExpiry;

    public HealthCheckProxy(Builder builder) {
      this(builder, true);
    }

    private HealthCheckProxy(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "connector.healthCheckProxy must be initialized: " + builder.__uninitialized);

      enable = (builder.enable == null) ?
          new BooleanNode(false) : new BooleanNode(builder.enable);
      port = (builder.port == null) ?
          new IntegerNode(8080) : new IntegerNode(builder.port);
      clientTimeout = (builder.clientTimeout == null) ?
          new DoubleNode(1.0D) : new DoubleNode(builder.clientTimeout);
      handlerTimeout = (builder.handlerTimeout == null) ?
          new DoubleNode(1.5D) : new DoubleNode(builder.handlerTimeout);
      cacheExpiry = (builder.cacheExpiry == null) ?
          new DoubleNode(1.0D) : new DoubleNode(builder.cacheExpiry);
    }

    /**
     * @return connector.healthCheckProxy.enable
     */
    public boolean enable() {
      return enable.value();
    }

    /**
     * @return connector.healthCheckProxy.port
     */
    public int port() {
      return port.value();
    }

    /**
     * @return connector.healthCheckProxy.clientTimeout
     */
    public double clientTimeout() {
      return clientTimeout.value();
    }

    /**
     * @return connector.healthCheckProxy.handlerTimeout
     */
    public double handlerTimeout() {
      return handlerTimeout.value();
    }

    /**
     * @return connector.healthCheckProxy.cacheExpiry
     */
    public double cacheExpiry() {
      return cacheExpiry.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(HealthCheckProxy newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("healthCheckProxy");
      return changes;
    }
  }

  /**
   * This class represents connector.proxyProtocol
   */
  public final static class ProxyProtocol extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Boolean enabled = null;
      private Boolean mixedMode = null;

      public Builder() { }

      public Builder(ProxyProtocol config) {
        enabled(config.enabled());
        mixedMode(config.mixedMode());
      }

      private Builder override(Builder __superior) {
        if (__superior.enabled != null)
          enabled(__superior.enabled);
        if (__superior.mixedMode != null)
          mixedMode(__superior.mixedMode);
        return this;
      }

      public Builder enabled(boolean __value) {
        enabled = __value;
        return this;
      }

      private Builder enabled(String __value) {
        return enabled(Boolean.valueOf(__value));
      }

      public Builder mixedMode(boolean __value) {
        mixedMode = __value;
        return this;
      }

      private Builder mixedMode(String __value) {
        return mixedMode(Boolean.valueOf(__value));
      }

      public ProxyProtocol build() {
        return new ProxyProtocol(this);
      }

    }

    // Enable PROXY protocol V1/V2 support (only for https connectors).
    private final BooleanNode enabled;
    // Allow https in parallel with proxy protocol
    // TODO Vespa 9 Remove
    // Unused since 8.327
    private final BooleanNode mixedMode;

    public ProxyProtocol(Builder builder) {
      this(builder, true);
    }

    private ProxyProtocol(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "connector.proxyProtocol must be initialized: " + builder.__uninitialized);

      enabled = (builder.enabled == null) ?
          new BooleanNode(false) : new BooleanNode(builder.enabled);
      mixedMode = (builder.mixedMode == null) ?
          new BooleanNode(false) : new BooleanNode(builder.mixedMode);
    }

    /**
     * @return connector.proxyProtocol.enabled
     */
    public boolean enabled() {
      return enabled.value();
    }

    /**
     * @return connector.proxyProtocol.mixedMode
     */
    public boolean mixedMode() {
      return mixedMode.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ProxyProtocol newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("proxyProtocol");
      return changes;
    }
  }

  /**
   * This class represents connector.http2
   */
  public final static class Http2 extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private Double streamIdleTimeout = null;
      private Integer maxConcurrentStreams = null;

      public Builder() { }

      public Builder(Http2 config) {
        streamIdleTimeout(config.streamIdleTimeout());
        maxConcurrentStreams(config.maxConcurrentStreams());
      }

      private Builder override(Builder __superior) {
        if (__superior.streamIdleTimeout != null)
          streamIdleTimeout(__superior.streamIdleTimeout);
        if (__superior.maxConcurrentStreams != null)
          maxConcurrentStreams(__superior.maxConcurrentStreams);
        return this;
      }

      public Builder streamIdleTimeout(double __value) {
        streamIdleTimeout = __value;
        return this;
      }

      private Builder streamIdleTimeout(String __value) {
        return streamIdleTimeout(Double.valueOf(__value));
      }

      public Builder maxConcurrentStreams(int __value) {
        maxConcurrentStreams = __value;
        return this;
      }

      private Builder maxConcurrentStreams(String __value) {
        return maxConcurrentStreams(Integer.valueOf(__value));
      }

      public Http2 build() {
        return new Http2(this);
      }

    }

    private final DoubleNode streamIdleTimeout;
    private final IntegerNode maxConcurrentStreams;

    public Http2(Builder builder) {
      this(builder, true);
    }

    private Http2(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "connector.http2 must be initialized: " + builder.__uninitialized);

      streamIdleTimeout = (builder.streamIdleTimeout == null) ?
          new DoubleNode(600D) : new DoubleNode(builder.streamIdleTimeout);
      maxConcurrentStreams = (builder.maxConcurrentStreams == null) ?
          new IntegerNode(512) : new IntegerNode(builder.maxConcurrentStreams);
    }

    /**
     * @return connector.http2.streamIdleTimeout
     */
    public double streamIdleTimeout() {
      return streamIdleTimeout.value();
    }

    /**
     * @return connector.http2.maxConcurrentStreams
     */
    public int maxConcurrentStreams() {
      return maxConcurrentStreams.value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Http2 newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("http2");
      return changes;
    }
  }

  /**
   * This class represents connector.serverName
   */
  public final static class ServerName extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      private String fallback = null;
      public List<String> allowed = new ArrayList<>();
      public List<String> known = new ArrayList<>();

      public Builder() { }

      public Builder(ServerName config) {
        fallback(config.fallback());
        allowed(config.allowed());
        known(config.known());
      }

      private Builder override(Builder __superior) {
        if (__superior.fallback != null)
          fallback(__superior.fallback);
        if (!__superior.allowed.isEmpty())
          allowed.addAll(__superior.allowed);
        if (!__superior.known.isEmpty())
          known.addAll(__superior.known);
        return this;
      }

      public Builder fallback(String __value) {
      if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
        fallback = __value;
        return this;
      }


      public Builder allowed(String __value) {
        allowed.add(__value);
        return this;
      }

      public Builder allowed(Collection<String> __values) {
        allowed.addAll(__values);
        return this;
      }

      public Builder known(String __value) {
        known.add(__value);
        return this;
      }

      public Builder known(Collection<String> __values) {
        known.addAll(__values);
        return this;
      }

      public ServerName build() {
        return new ServerName(this);
      }

    }

    // Override the default server name when authority is missing from request.
    private final StringNode fallback;
    // The list of accepted server names. Empty list to accept any. Elements follows format of 'serverName.default'.
    private final LeafNodeVector<String, StringNode> allowed;
    // The list of known server names. Used for e.g matching metric dimensions.
    private final LeafNodeVector<String, StringNode> known;

    public ServerName(Builder builder) {
      this(builder, true);
    }

    private ServerName(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "connector.serverName must be initialized: " + builder.__uninitialized);

      fallback = (builder.fallback == null) ?
          new StringNode("") : new StringNode(builder.fallback);
      allowed = new LeafNodeVector<>(builder.allowed, new StringNode());
      known = new LeafNodeVector<>(builder.known, new StringNode());
    }

    /**
     * @return connector.serverName.fallback
     */
    public String fallback() {
      return fallback.value();
    }

    /**
     * @return connector.serverName.allowed[]
     */
    public List<String> allowed() {
      return allowed.asList();
    }

    /**
     * @param i the index of the value to return
     * @return connector.serverName.allowed[]
     */
    public String allowed(int i) {
      return allowed.get(i).value();
    }

    /**
     * @return connector.serverName.known[]
     */
    public List<String> known() {
      return known.asList();
    }

    /**
     * @param i the index of the value to return
     * @return connector.serverName.known[]
     */
    public String known(int i) {
      return known.get(i).value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(ServerName newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("serverName");
      return changes;
    }
  }

  /**
   * This class represents connector.accessLog
   */
  public final static class AccessLog extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      public List<String> remoteAddressHeaders = new ArrayList<>();
      public List<String> remotePortHeaders = new ArrayList<>();
      public List<Content.Builder> content = new ArrayList<>();

      public Builder() { }

      public Builder(AccessLog config) {
        remoteAddressHeaders(config.remoteAddressHeaders());
        remotePortHeaders(config.remotePortHeaders());
        for (Content c : config.content()) {
          content(new Content.Builder(c));
        }
      }

      private Builder override(Builder __superior) {
        if (!__superior.remoteAddressHeaders.isEmpty())
          remoteAddressHeaders.addAll(__superior.remoteAddressHeaders);
        if (!__superior.remotePortHeaders.isEmpty())
          remotePortHeaders.addAll(__superior.remotePortHeaders);
        if (!__superior.content.isEmpty())
          content.addAll(__superior.content);
        return this;
      }

      public Builder remoteAddressHeaders(String __value) {
        remoteAddressHeaders.add(__value);
        return this;
      }

      public Builder remoteAddressHeaders(Collection<String> __values) {
        remoteAddressHeaders.addAll(__values);
        return this;
      }

      public Builder remotePortHeaders(String __value) {
        remotePortHeaders.add(__value);
        return this;
      }

      public Builder remotePortHeaders(Collection<String> __values) {
        remotePortHeaders.addAll(__values);
        return this;
      }

      /**
       * Add the given builder to this builder's list of Content builders
       * @param __builder a builder
       * @return this builder
       */
      public Builder content(Content.Builder __builder) {
        content.add(__builder);
        return this;
      }

      /**
       * Make a new builder and run the supplied function on it before adding it to the list
       * @param __func lambda that modifies the given builder
       * @return this builder
       */
      public Builder content(java.util.function.Consumer<Content.Builder> __func) {
        Content.Builder __inner = new Content.Builder();
        __func.accept(__inner);
        content.add(__inner);
        return this;
      }

      /**
       * Set the given list as this builder's list of Content builders
       * @param __builders a list of builders
       * @return this builder
       */
      public Builder content(List<Content.Builder> __builders) {
        content = __builders;
        return this;
      }

      public AccessLog build() {
        return new AccessLog(this);
      }

    }

    // HTTP request headers that contain remote address
    private final LeafNodeVector<String, StringNode> remoteAddressHeaders;
    // HTTP request headers that contain remote port
    private final LeafNodeVector<String, StringNode> remotePortHeaders;
    private final InnerNodeVector<Content> content;

    public AccessLog(Builder builder) {
      this(builder, true);
    }

    private AccessLog(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "connector.accessLog must be initialized: " + builder.__uninitialized);

      remoteAddressHeaders = new LeafNodeVector<>(builder.remoteAddressHeaders, new StringNode());
      remotePortHeaders = new LeafNodeVector<>(builder.remotePortHeaders, new StringNode());
      content = Content.createVector(builder.content);
    }

    /**
     * @return connector.accessLog.remoteAddressHeaders[]
     */
    public List<String> remoteAddressHeaders() {
      return remoteAddressHeaders.asList();
    }

    /**
     * @param i the index of the value to return
     * @return connector.accessLog.remoteAddressHeaders[]
     */
    public String remoteAddressHeaders(int i) {
      return remoteAddressHeaders.get(i).value();
    }

    /**
     * @return connector.accessLog.remotePortHeaders[]
     */
    public List<String> remotePortHeaders() {
      return remotePortHeaders.asList();
    }

    /**
     * @param i the index of the value to return
     * @return connector.accessLog.remotePortHeaders[]
     */
    public String remotePortHeaders(int i) {
      return remotePortHeaders.get(i).value();
    }

    /**
     * @return connector.accessLog.content[]
     */
    public List<Content> content() {
      return content;
    }

    /**
     * @param i the index of the value to return
     * @return connector.accessLog.content[]
     */
    public Content content(int i) {
      return content.get(i);
    }

    private ChangesRequiringRestart getChangesRequiringRestart(AccessLog newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("accessLog");
      return changes;
    }

    /**
     * This class represents connector.accessLog.content[]
     */
    public final static class Content extends InnerNode { 

      public static final class Builder implements ConfigBuilder {
        private Set<String> __uninitialized = new HashSet<String>(List.of(
          "pathPrefix",
          "maxSize",
          "sampleRate"
          ));

        private String pathPrefix = null;
        private Long maxSize = null;
        private Double sampleRate = null;

        public Builder() { }

        public Builder(Content config) {
          pathPrefix(config.pathPrefix());
          maxSize(config.maxSize());
          sampleRate(config.sampleRate());
        }

        private Builder override(Builder __superior) {
          if (__superior.pathPrefix != null)
            pathPrefix(__superior.pathPrefix);
          if (__superior.maxSize != null)
            maxSize(__superior.maxSize);
          if (__superior.sampleRate != null)
            sampleRate(__superior.sampleRate);
          return this;
        }

        public Builder pathPrefix(String __value) {
        if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
          pathPrefix = __value;
          __uninitialized.remove("pathPrefix");
          return this;
        }


        public Builder maxSize(long __value) {
          maxSize = __value;
          __uninitialized.remove("maxSize");
          return this;
        }

        private Builder maxSize(String __value) {
          return maxSize(Long.valueOf(__value));
        }

        public Builder sampleRate(double __value) {
          sampleRate = __value;
          __uninitialized.remove("sampleRate");
          return this;
        }

        private Builder sampleRate(String __value) {
          return sampleRate(Double.valueOf(__value));
        }

        public Content build() {
          return new Content(this);
        }

      }

      // Path prefixes for which content should be logged
      private final StringNode pathPrefix;
      // Maximum size of content to log, in bytes
      private final LongNode maxSize;
      // Probabilistic sample rate, per second
      private final DoubleNode sampleRate;

      public Content(Builder builder) {
        this(builder, true);
      }

      private Content(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
          throw new IllegalArgumentException("The following builder parameters for " +
              "connector.accessLog.content[] must be initialized: " + builder.__uninitialized);

        pathPrefix = (builder.pathPrefix == null) ?
            new StringNode() : new StringNode(builder.pathPrefix);
        maxSize = (builder.maxSize == null) ?
            new LongNode() : new LongNode(builder.maxSize);
        sampleRate = (builder.sampleRate == null) ?
            new DoubleNode() : new DoubleNode(builder.sampleRate);
      }

      /**
       * @return connector.accessLog.content[].pathPrefix
       */
      public String pathPrefix() {
        return pathPrefix.value();
      }

      /**
       * @return connector.accessLog.content[].maxSize
       */
      public long maxSize() {
        return maxSize.value();
      }

      /**
       * @return connector.accessLog.content[].sampleRate
       */
      public double sampleRate() {
        return sampleRate.value();
      }

      private ChangesRequiringRestart getChangesRequiringRestart(Content newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart("content");
        return changes;
      }

      private static InnerNodeVector<Content> createVector(List<Builder> builders) {
          List<Content> elems = new ArrayList<>();
          for (Builder b : builders) {
              elems.add(new Content(b));
          }
          return new InnerNodeVector<Content>(elems);
      }
    }
  }

  /**
   * This class represents connector.compliance
   */
  public final static class Compliance extends InnerNode { 

    public static final class Builder implements ConfigBuilder {
      private Set<String> __uninitialized = new HashSet<String>();

      public List<String> httpViolations = new ArrayList<>();

      public Builder() { }

      public Builder(Compliance config) {
        httpViolations(config.httpViolations());
      }

      private Builder override(Builder __superior) {
        if (!__superior.httpViolations.isEmpty())
          httpViolations.addAll(__superior.httpViolations);
        return this;
      }

      public Builder httpViolations(String __value) {
        httpViolations.add(__value);
        return this;
      }

      public Builder httpViolations(Collection<String> __values) {
        httpViolations.addAll(__values);
        return this;
      }

      public Compliance build() {
        return new Compliance(this);
      }

    }

    private final LeafNodeVector<String, StringNode> httpViolations;

    public Compliance(Builder builder) {
      this(builder, true);
    }

    private Compliance(Builder builder, boolean throwIfUninitialized) {
      if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
        throw new IllegalArgumentException("The following builder parameters for " +
            "connector.compliance must be initialized: " + builder.__uninitialized);

      httpViolations = new LeafNodeVector<>(builder.httpViolations, new StringNode());
    }

    /**
     * @return connector.compliance.httpViolations[]
     */
    public List<String> httpViolations() {
      return httpViolations.asList();
    }

    /**
     * @param i the index of the value to return
     * @return connector.compliance.httpViolations[]
     */
    public String httpViolations(int i) {
      return httpViolations.get(i).value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(Compliance newConfig) {
      ChangesRequiringRestart changes = new ChangesRequiringRestart("compliance");
      return changes;
    }
  }

}
