// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.container.logging;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of connection-log
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class ConnectionLogConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "fd954a684c48e3ac2ea435b5b7a1e0d7";
  public final static String CONFIG_DEF_NAME = "connection-log";
  public final static String CONFIG_DEF_NAMESPACE = "container.logging";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=container.logging",
    "cluster string",
    "logDirectoryName string default=\"qrs\"",
    "queueSize int default=10000",
    "bufferSize int default=262144",
    "useClusterIdInFileName bool default=true"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>(List.of(
      "cluster"
      ));

    private String cluster = null;
    private String logDirectoryName = null;
    private Integer queueSize = null;
    private Integer bufferSize = null;
    private Boolean useClusterIdInFileName = null;

    public Builder() { }

    public Builder(ConnectionLogConfig config) {
      cluster(config.cluster());
      logDirectoryName(config.logDirectoryName());
      queueSize(config.queueSize());
      bufferSize(config.bufferSize());
      useClusterIdInFileName(config.useClusterIdInFileName());
    }

    private Builder override(Builder __superior) {
      if (__superior.cluster != null)
        cluster(__superior.cluster);
      if (__superior.logDirectoryName != null)
        logDirectoryName(__superior.logDirectoryName);
      if (__superior.queueSize != null)
        queueSize(__superior.queueSize);
      if (__superior.bufferSize != null)
        bufferSize(__superior.bufferSize);
      if (__superior.useClusterIdInFileName != null)
        useClusterIdInFileName(__superior.useClusterIdInFileName);
      return this;
    }

    public Builder cluster(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      cluster = __value;
      __uninitialized.remove("cluster");
      return this;
    }


    public Builder logDirectoryName(String __value) {
    if (__value == null) throw new IllegalArgumentException("Null value is not allowed.");
      logDirectoryName = __value;
      return this;
    }


    public Builder queueSize(int __value) {
      queueSize = __value;
      return this;
    }

    private Builder queueSize(String __value) {
      return queueSize(Integer.valueOf(__value));
    }

    public Builder bufferSize(int __value) {
      bufferSize = __value;
      return this;
    }

    private Builder bufferSize(String __value) {
      return bufferSize(Integer.valueOf(__value));
    }

    public Builder useClusterIdInFileName(boolean __value) {
      useClusterIdInFileName = __value;
      return this;
    }

    private Builder useClusterIdInFileName(String __value) {
      return useClusterIdInFileName(Boolean.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public ConnectionLogConfig build() {
      return new ConnectionLogConfig(this);
    }

  }

  // Name of the cluster
  private final StringNode cluster;
  // Log directory name
  private final StringNode logDirectoryName;
  // Max queue length of file handler
  private final IntegerNode queueSize;
  // Buffer size for the output stream has a default of 256k
  private final IntegerNode bufferSize;
  // In hosted Vespa we do not use the clusterId in file names for application containers
  private final BooleanNode useClusterIdInFileName;

  public ConnectionLogConfig(Builder builder) {
    this(builder, true);
  }

  private ConnectionLogConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "connection-log must be initialized: " + builder.__uninitialized);

    cluster = (builder.cluster == null) ?
        new StringNode() : new StringNode(builder.cluster);
    logDirectoryName = (builder.logDirectoryName == null) ?
        new StringNode("qrs") : new StringNode(builder.logDirectoryName);
    queueSize = (builder.queueSize == null) ?
        new IntegerNode(10000) : new IntegerNode(builder.queueSize);
    bufferSize = (builder.bufferSize == null) ?
        new IntegerNode(262144) : new IntegerNode(builder.bufferSize);
    useClusterIdInFileName = (builder.useClusterIdInFileName == null) ?
        new BooleanNode(true) : new BooleanNode(builder.useClusterIdInFileName);
  }

  /**
   * @return connection-log.cluster
   */
  public String cluster() {
    return cluster.value();
  }

  /**
   * @return connection-log.logDirectoryName
   */
  public String logDirectoryName() {
    return logDirectoryName.value();
  }

  /**
   * @return connection-log.queueSize
   */
  public int queueSize() {
    return queueSize.value();
  }

  /**
   * @return connection-log.bufferSize
   */
  public int bufferSize() {
    return bufferSize.value();
  }

  /**
   * @return connection-log.useClusterIdInFileName
   */
  public boolean useClusterIdInFileName() {
    return useClusterIdInFileName.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(ConnectionLogConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("connection-log");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
