/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.processing.request;

import com.yahoo.concurrent.CopyOnWriteHashMap;
import com.yahoo.text.Lowercase;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class CompoundName {
    private static final int MAX_CACHE_SIZE = 10000;
    private static final Map<String, CompoundName> cache = new CopyOnWriteHashMap();
    public static final CompoundName empty = CompoundName.from("");
    private final String name;
    private final String lowerCasedName;
    private final List<String> compounds;
    private final int hashCode;
    private final CompoundName rest;
    private final CompoundName first;

    public CompoundName(String name) {
        this(name, false);
    }

    private CompoundName(String name, boolean useCache) {
        this(name, CompoundName.parse(name).toArray(new String[0]), useCache);
    }

    public static CompoundName fromComponents(String ... components) {
        return new CompoundName(List.of(components));
    }

    public CompoundName(List<String> compounds) {
        this(compounds.toArray(new String[0]));
    }

    private CompoundName(String[] compounds) {
        this(CompoundName.toCompoundString(compounds), compounds, true);
    }

    private CompoundName(String name, String[] compounds, boolean useCache) {
        this.name = Objects.requireNonNull(name, "Name can not be null");
        this.lowerCasedName = Lowercase.toLowerCase((String)name);
        if (compounds.length == 1) {
            if (compounds[0].isEmpty()) {
                this.compounds = List.of();
                this.hashCode = 0;
                this.rest = this.first = this;
                return;
            }
            this.compounds = new ImmutableArrayList(compounds);
            this.hashCode = this.compounds.hashCode();
            this.rest = this.first = empty;
            return;
        }
        CompoundName[] children = new CompoundName[compounds.length];
        int i = 0;
        while (i + 1 < children.length) {
            int start = 0;
            int end = i == 0 ? -1 : children[0].name.length();
            int j = 0;
            while (j + i < children.length) {
                if ((end += compounds[j + i].length() + 1) == start) {
                    throw new IllegalArgumentException("'" + name + "' is not a legal compound name. Consecutive, leading or trailing dots are not allowed.");
                }
                String subName = this.name.substring(start, end);
                CompoundName cached = cache.get(subName);
                CompoundName compoundName = cached != null ? cached : (children[j] = new CompoundName(subName, this.lowerCasedName.substring(start, end), Arrays.copyOfRange(compounds, j, j + i + 1), i == 0 ? empty : children[j + 1], i == 0 ? empty : children[j]));
                if (useCache && cached == null) {
                    cache.put(subName, children[j]);
                }
                start += compounds[j].length() + 1;
                ++j;
            }
            ++i;
        }
        this.compounds = new ImmutableArrayList(compounds);
        this.hashCode = this.compounds.hashCode();
        this.rest = children[1];
        this.first = children[0];
    }

    private CompoundName(String name, String lowerCasedName, String[] compounds, CompoundName rest, CompoundName first) {
        this.name = name;
        this.lowerCasedName = lowerCasedName;
        this.compounds = new ImmutableArrayList(compounds);
        this.hashCode = this.compounds.hashCode();
        this.rest = rest;
        this.first = first;
    }

    private static List<String> parse(String s) {
        ArrayList<String> l = null;
        int p = 0;
        int m = s.length();
        for (int i = 0; i < m; ++i) {
            if (s.charAt(i) != '.') continue;
            if (l == null) {
                l = new ArrayList<String>(8);
            }
            l.add(s.substring(p, i));
            p = i + 1;
        }
        if (p == 0) {
            if (l == null) {
                return List.of(s);
            }
            l.add(s);
        } else if (p < m) {
            l.add(s.substring(p, m));
        } else {
            throw new IllegalArgumentException("'" + s + "' is not a legal compound name. Names can not end with a dot.");
        }
        return l;
    }

    public CompoundName append(String name) {
        if (name.isEmpty()) {
            return this;
        }
        return this.append(new CompoundName(name));
    }

    public CompoundName append(CompoundName name) {
        if (name.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return name;
        }
        String[] newCompounds = new String[this.compounds.size() + name.compounds.size()];
        int count = 0;
        for (String s : this.compounds) {
            newCompounds[count++] = s;
        }
        for (String s : name.compounds) {
            newCompounds[count++] = s;
        }
        return new CompoundName(CompoundName.concat(this.name, name.name), newCompounds, false);
    }

    private static String concat(String name1, String name2) {
        return name1 + "." + name2;
    }

    public CompoundName prepend(String ... nameParts) {
        if (nameParts.length == 0) {
            return this;
        }
        if (this.isEmpty()) {
            return CompoundName.fromComponents(nameParts);
        }
        ArrayList<String> newCompounds = new ArrayList<String>(nameParts.length + this.compounds.size());
        newCompounds.addAll(List.of(nameParts));
        newCompounds.addAll(this.compounds);
        return new CompoundName(newCompounds);
    }

    public String last() {
        if (this.compounds.isEmpty()) {
            return "";
        }
        return this.compounds.get(this.compounds.size() - 1);
    }

    public String first() {
        if (this.compounds.isEmpty()) {
            return "";
        }
        return this.compounds.get(0);
    }

    public CompoundName first(int n) {
        if (this.compounds.size() < n) {
            throw new IllegalArgumentException("Asked for the first " + n + " components but '" + String.valueOf(this) + "' only have " + this.compounds.size() + " components.");
        }
        if (this.compounds.size() == n) {
            return this;
        }
        if (this.compounds.isEmpty()) {
            return empty;
        }
        if (this.compounds.size() - 1 == n) {
            return this.first;
        }
        return this.first.first(n);
    }

    public CompoundName rest() {
        return this.rest;
    }

    public CompoundName rest(int n) {
        if (n == 0) {
            return this;
        }
        if (this.compounds.size() < n) {
            throw new IllegalArgumentException("Asked for the rest after " + n + " components but '" + String.valueOf(this) + "' only have " + this.compounds.size() + " components.");
        }
        if (n == 1) {
            return this.rest();
        }
        if (this.compounds.size() == n) {
            return empty;
        }
        return this.rest.rest(n - 1);
    }

    public int size() {
        return this.compounds.size();
    }

    public String get(int i) {
        return this.compounds.get(i);
    }

    public CompoundName set(int i, String name) {
        if (this.get(i).equals(name)) {
            return this;
        }
        ArrayList<String> newCompounds = new ArrayList<String>(this.compounds);
        newCompounds.set(i, name);
        return new CompoundName(newCompounds);
    }

    public boolean isCompound() {
        return this.compounds.size() > 1;
    }

    public boolean isEmpty() {
        return this.compounds.isEmpty();
    }

    public boolean hasPrefix(CompoundName prefix) {
        if (prefix.size() > this.size()) {
            return false;
        }
        int prefixLength = prefix.name.length();
        if (prefixLength == 0) {
            return true;
        }
        if (this.name.length() > prefixLength && this.name.charAt(prefixLength) != '.') {
            return false;
        }
        return this.name.startsWith(prefix.name);
    }

    public List<String> asList() {
        return this.compounds;
    }

    public int hashCode() {
        return this.hashCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object arg) {
        if (arg == this) {
            return true;
        }
        if (!(arg instanceof CompoundName)) return false;
        CompoundName o = (CompoundName)arg;
        if (!this.name.equals(o.name)) return false;
        return true;
    }

    public String toString() {
        return this.name;
    }

    public String getLowerCasedName() {
        return this.lowerCasedName;
    }

    private static String toCompoundString(String[] compounds) {
        int all = compounds.length;
        for (String compound : compounds) {
            all += compound.length();
        }
        StringBuilder b = new StringBuilder(all);
        for (String compound : compounds) {
            b.append(compound).append(".");
        }
        return b.isEmpty() ? "" : b.substring(0, b.length() - 1);
    }

    public static CompoundName from(String name) {
        CompoundName found = cache.get(name);
        if (found != null) {
            return found;
        }
        if (cache.size() < 10000) {
            CompoundName compound = new CompoundName(name, true);
            cache.put(name, compound);
            return compound;
        }
        return new CompoundName(name, false);
    }

    private static class ImmutableArrayList
    extends AbstractList<String> {
        private final String[] array;

        ImmutableArrayList(String[] array) {
            this.array = array;
        }

        @Override
        public String get(int index) {
            return this.array[index];
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public int hashCode() {
            int hashCode = 0;
            for (String s : this.array) {
                hashCode ^= s.hashCode();
            }
            return hashCode;
        }
    }
}

