/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.handler;

import com.yahoo.component.annotation.Inject;
import com.yahoo.container.core.LogHandlerConfig;
import com.yahoo.container.handler.LogReader;
import com.yahoo.container.jdisc.AsyncHttpResponse;
import com.yahoo.container.jdisc.HttpRequest;
import com.yahoo.container.jdisc.RequestView;
import com.yahoo.container.jdisc.ThreadedHttpRequestHandler;
import com.yahoo.container.jdisc.utils.CapabilityRequiringRequestHandler;
import com.yahoo.jdisc.handler.CompletionHandler;
import com.yahoo.jdisc.handler.ContentChannel;
import com.yahoo.security.tls.Capability;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.logging.Level;

public class LogHandler
extends ThreadedHttpRequestHandler
implements CapabilityRequiringRequestHandler {
    private final LogReader logReader;
    private static final long MB = 0x100000L;

    @Inject
    public LogHandler(Executor executor, LogHandlerConfig config) {
        this(executor, new LogReader(config.logDirectory(), config.logPattern()));
    }

    LogHandler(Executor executor, LogReader logReader) {
        super(executor);
        this.logReader = logReader;
    }

    @Override
    public Capability requiredCapability(RequestView __) {
        return Capability.LOGSERVER_API;
    }

    @Override
    public AsyncHttpResponse handle(HttpRequest request) {
        final Instant from = Optional.ofNullable(request.getProperty("from")).map(Long::valueOf).map(Instant::ofEpochMilli).orElse(Instant.MIN);
        final Instant to = Optional.ofNullable(request.getProperty("to")).map(Long::valueOf).map(Instant::ofEpochMilli).orElse(Instant.MAX);
        final long maxLines = Optional.ofNullable(request.getProperty("maxLines")).map(Long::valueOf).orElse(100000L);
        final Optional<String> hostname = Optional.ofNullable(request.getProperty("hostname"));
        return new AsyncHttpResponse(200){

            @Override
            public long maxPendingBytes() {
                return 0x100000L;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void render(OutputStream output, ContentChannel networkChannel, CompletionHandler handler) {
                try (OutputStream outputStream = output;){
                    LogHandler.this.logReader.writeLogs(output, from, to, maxLines, hostname);
                }
                catch (Throwable t) {
                    LogHandler.this.log.log(Level.WARNING, "Failed reading logs from " + String.valueOf(from) + " to " + String.valueOf(to), t);
                }
                finally {
                    networkChannel.close(handler);
                }
            }
        };
    }
}

