/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.restapi;

import ai.vespa.http.HttpURL;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class Path {
    private final HttpURL.Path path;
    private final Map<String, String> values = new HashMap<String, String>();
    private HttpURL.Path rest;

    public Path(URI uri) {
        this.path = HttpURL.Path.parse((String)uri.getRawPath());
    }

    public Path(URI uri, Consumer<String> validator) {
        this.path = HttpURL.Path.parse((String)uri.getRawPath(), validator);
    }

    public static Path withoutValidation(URI uri) {
        return new Path(uri, __ -> {});
    }

    private boolean matchesInner(String pathSpec) {
        this.values.clear();
        List specElements = HttpURL.Path.parse((String)pathSpec).segments();
        boolean matchPrefix = false;
        if (specElements.size() > 1 && ((String)specElements.get(specElements.size() - 1)).equals("{*}")) {
            matchPrefix = true;
            specElements = specElements.subList(0, specElements.size() - 1);
        }
        if (matchPrefix ? this.path.length() < specElements.size() : this.path.length() != specElements.size()) {
            return false;
        }
        List segments = this.path.segments();
        for (int i = 0; i < specElements.size(); ++i) {
            if (((String)specElements.get(i)).startsWith("{") && ((String)specElements.get(i)).endsWith("}")) {
                this.values.put(((String)specElements.get(i)).substring(1, ((String)specElements.get(i)).length() - 1), (String)segments.get(i));
                continue;
            }
            if (((String)specElements.get(i)).equals(segments.get(i))) continue;
            return false;
        }
        this.rest = matchPrefix ? this.path.skip(specElements.size()) : null;
        return true;
    }

    public boolean matches(String pathSpec) {
        return this.matchesInner(pathSpec);
    }

    public String get(String placeholder) {
        return this.values.get(placeholder);
    }

    public HttpURL.Path getRest() {
        return this.rest;
    }

    public HttpURL.Path getPath() {
        return this.path;
    }

    public String toString() {
        return this.path.toString();
    }
}

