/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.osgi;

import com.yahoo.component.ComponentSpecification;
import com.yahoo.component.Version;
import com.yahoo.container.bundle.BundleInstantiationSpecification;
import com.yahoo.jdisc.application.OsgiFramework;
import com.yahoo.osgi.Osgi;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.launch.Framework;

public class OsgiImpl
implements Osgi {
    private static final Logger log = Logger.getLogger(OsgiImpl.class.getName());
    private final OsgiFramework jdiscOsgi;
    private final List<Bundle> initialBundles;
    private final Bundle systemBundle;
    private final Bundle alwaysCurrentBundle;

    public OsgiImpl(OsgiFramework jdiscOsgi) {
        this.jdiscOsgi = jdiscOsgi;
        this.initialBundles = jdiscOsgi.bundles();
        if (this.initialBundles.isEmpty()) {
            throw new IllegalStateException("No initial bundles!");
        }
        this.systemBundle = OsgiImpl.getSystemBundle(this.initialBundles, jdiscOsgi);
        this.alwaysCurrentBundle = OsgiImpl.firstNonFrameworkBundle(this.initialBundles);
        if (this.alwaysCurrentBundle == null) {
            throw new IllegalStateException("The initial bundles only contained the framework bundle!");
        }
        log.fine("Using " + String.valueOf(this.alwaysCurrentBundle) + " to lookup current bundles.");
    }

    @Override
    public Bundle[] getBundles() {
        List bundles = this.jdiscOsgi.bundles();
        return bundles.toArray(new Bundle[bundles.size()]);
    }

    @Override
    public List<Bundle> getCurrentBundles() {
        return this.jdiscOsgi.getBundles(this.alwaysCurrentBundle);
    }

    public Class<?> resolveClass(BundleInstantiationSpecification spec) {
        Bundle bundle = this.getBundle(spec.bundle);
        if (bundle != null) {
            return OsgiImpl.resolveFromBundle(spec, bundle);
        }
        if (this.jdiscOsgi.isFelixFramework() && !spec.bundle.equals((Object)spec.classId)) {
            throw new IllegalArgumentException("Could not find bundle " + String.valueOf(spec.bundle) + " to create a component with class '" + spec.classId.getName() + ". " + this.bundleResolutionErrorMessage(spec.bundle));
        }
        return this.resolveFromThisBundleOrSystemBundle(spec);
    }

    private Class<Object> resolveFromThisBundleOrSystemBundle(BundleInstantiationSpecification spec) {
        log.fine(() -> "Resolving class from container-disc: " + spec.classId.getName());
        try {
            return Class.forName(spec.classId.getName());
        }
        catch (ClassNotFoundException e) {
            if (this.hasFelixFramework()) {
                log.fine(() -> "Resolving class from the system bundle (jdisc core): " + spec.classId.getName());
                try {
                    return this.systemBundle.loadClass(spec.classId.getName());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException("Could not create a component with class '" + spec.classId.getName() + "'. Tried to load class directly, since no bundle was found for spec: " + String.valueOf(spec.bundle) + ". " + this.bundleResolutionErrorMessage(spec.bundle));
        }
    }

    protected String bundleResolutionErrorMessage(ComponentSpecification bundleSpec) {
        return "If a bundle with the same name is installed, there is a either a version mismatch or the installed bundle's version contains a qualifier string.";
    }

    private static Class<Object> resolveFromBundle(BundleInstantiationSpecification spec, Bundle bundle) {
        try {
            OsgiImpl.ensureBundleActive(bundle);
            return bundle.loadClass(spec.classId.getName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not load class '" + spec.classId.getName() + "' from bundle " + String.valueOf(bundle), e);
        }
    }

    private static void ensureBundleActive(Bundle bundle) throws IllegalStateException {
        int state = bundle.getState();
        BundleException cause = null;
        if (state != 32) {
            try {
                bundle.start();
            }
            catch (BundleException e) {
                cause = e;
            }
            throw new IllegalStateException("Bundle " + String.valueOf(bundle) + " is not active. State=" + state + ".", cause);
        }
    }

    @Override
    public Bundle getBundle(ComponentSpecification id) {
        log.fine(() -> "Getting bundle for component " + String.valueOf(id) + ". Set of current bundles: " + String.valueOf(this.getCurrentBundles()));
        Bundle highestMatch = null;
        for (Bundle bundle : this.getCurrentBundles()) {
            assert (bundle.getSymbolicName() != null) : "ensureHasBundleSymbolicName not called during installation";
            if (!bundle.getSymbolicName().equals(id.getName()) || !id.getVersionSpecification().matches(OsgiImpl.versionOf(bundle)) || highestMatch != null && OsgiImpl.versionOf(highestMatch).compareTo(OsgiImpl.versionOf(bundle)) >= 0) continue;
            highestMatch = bundle;
        }
        return highestMatch;
    }

    private static Version versionOf(Bundle bundle) {
        Object bundleVersion = bundle.getHeaders().get("Bundle-Version");
        if (bundleVersion == null) {
            return Version.emptyVersion;
        }
        return new Version(bundleVersion.toString());
    }

    @Override
    public List<Bundle> install(String absolutePath) {
        try {
            return this.jdiscOsgi.installBundle(OsgiImpl.normalizeLocation(absolutePath));
        }
        catch (BundleException e) {
            throw new RuntimeException(e);
        }
    }

    private static String normalizeLocation(String location) {
        if (((String)location).indexOf(58) < 0) {
            location = "file:" + (String)location;
        }
        return location;
    }

    @Override
    public void allowDuplicateBundles(Collection<Bundle> bundles) {
        this.jdiscOsgi.allowDuplicateBundles(bundles);
    }

    @Override
    public boolean hasFelixFramework() {
        return this.jdiscOsgi.isFelixFramework();
    }

    private static Bundle getSystemBundle(List<Bundle> bundles, OsgiFramework jdiscOsgi) {
        for (Bundle b : bundles) {
            if (!(b instanceof Framework)) continue;
            return b;
        }
        if (jdiscOsgi.isFelixFramework()) {
            throw new IllegalStateException("No system bundle in " + String.valueOf(bundles));
        }
        return null;
    }

    private static Bundle firstNonFrameworkBundle(List<Bundle> bundles) {
        for (Bundle b : bundles) {
            if (b instanceof Framework) continue;
            return b;
        }
        return null;
    }
}

