/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.jdisc.http;

import com.yahoo.jdisc.HeaderFields;
import com.yahoo.jdisc.Request;
import com.yahoo.jdisc.Response;
import com.yahoo.jdisc.http.Cookie;
import com.yahoo.jdisc.http.CookieHelper;
import java.util.List;
import java.util.Map;

public class HttpResponse
extends Response {
    private final HeaderFields trailers = new HeaderFields();
    private boolean chunkedEncodingEnabled = true;
    private String message;

    protected HttpResponse(Request request, int status, String message, Throwable error) {
        super(status, error);
        this.message = message;
    }

    public boolean isChunkedEncodingEnabled() {
        if (this.headers().contains("Transfer-Encoding", "chunked")) {
            return true;
        }
        if (this.headers().containsKey((Object)"Content-Length")) {
            return false;
        }
        return this.chunkedEncodingEnabled;
    }

    public void setChunkedEncodingEnabled(boolean chunkedEncodingEnabled) {
        this.chunkedEncodingEnabled = chunkedEncodingEnabled;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void copyHeaders(HeaderFields target) {
        target.addAll((Map)this.headers());
    }

    public List<Cookie> decodeSetCookieHeader() {
        return CookieHelper.decodeSetCookieHeader(this.headers());
    }

    public void encodeSetCookieHeader(List<Cookie> cookies) {
        CookieHelper.encodeSetCookieHeader(this.headers(), cookies);
    }

    public HeaderFields trailers() {
        return this.trailers;
    }

    public static boolean isServerError(Response response) {
        return response.getStatus() >= 500 && response.getStatus() < 600;
    }

    public static HttpResponse newInstance(int status) {
        return new HttpResponse(null, status, null, null);
    }

    public static HttpResponse newInstance(int status, String message) {
        return new HttpResponse(null, status, message, null);
    }

    public static HttpResponse newError(Request request, int status, Throwable error) {
        return new HttpResponse(request, status, HttpResponse.formatMessage(error), error);
    }

    public static HttpResponse newInternalServerError(Request request, Throwable error) {
        return new HttpResponse(request, 500, HttpResponse.formatMessage(error), error);
    }

    private static String formatMessage(Throwable t) {
        String msg = t.getMessage();
        return msg != null ? msg : t.toString();
    }

    public static interface Status
    extends Response.Status {
        public static final int REQUEST_ENTITY_TOO_LARGE = 413;
        public static final int REQUEST_RANGE_NOT_SATISFIABLE = 416;
    }
}

