/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.container.logging;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;

class FormatUtil {
    private FormatUtil() {
    }

    static void writeSecondsField(JsonGenerator generator, String fieldName, Instant instant) throws IOException {
        FormatUtil.writeSecondsField(generator, fieldName, instant.toEpochMilli());
    }

    static void writeSecondsField(JsonGenerator generator, String fieldName, Duration duration) throws IOException {
        FormatUtil.writeSecondsField(generator, fieldName, duration.toMillis());
    }

    static void writeSecondsField(JsonGenerator generator, String fieldName, double seconds) throws IOException {
        FormatUtil.writeSecondsField(generator, fieldName, (long)(seconds * 1000.0));
    }

    static void writeSecondsField(JsonGenerator generator, String fieldName, long milliseconds) throws IOException {
        generator.writeFieldName(fieldName);
        generator.writeRawValue(FormatUtil.toSecondsString(milliseconds));
    }

    static String toSecondsString(long milliseconds) {
        StringBuilder builder = new StringBuilder().append(milliseconds / 1000L).append('.');
        long decimals = milliseconds % 1000L;
        if (decimals < 100L) {
            builder.append('0');
            if (decimals < 10L) {
                builder.append('0');
            }
        }
        return builder.append(decimals).toString();
    }
}

