// ------------   D O   N O T   E D I T !   ------------
// This file is generated from a config definition file.

package com.yahoo.metrics;

import java.util.*;
import java.io.File;
import java.nio.file.Path;
import com.yahoo.config.*;

/**
 * This class represents the root node of manager
 *
 * Copyright Vespa.ai. Licensed under the terms of the Apache 2.0 license. See LICENSE in the project root.
 */
public final class ManagerConfig extends ConfigInstance {

  public final static String CONFIG_DEF_MD5 = "1ea23a258f89669bb15ccab48f7de011";
  public final static String CONFIG_DEF_NAME = "manager";
  public final static String CONFIG_DEF_NAMESPACE = "metrics";
  public final static String[] CONFIG_DEF_SCHEMA = {
    "namespace=metrics",
    "reportPeriodSeconds int default=60",
    "pointsToKeepPerMetric int default=100"
  };

  public static String getDefMd5()       { return CONFIG_DEF_MD5; }
  public static String getDefName()      { return CONFIG_DEF_NAME; }
  public static String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

  public interface Producer extends ConfigInstance.Producer {
    void getConfig(Builder builder);
  }

  public static final class Builder implements ConfigInstance.Builder {
    private Set<String> __uninitialized = new HashSet<String>();

    private Integer reportPeriodSeconds = null;
    private Integer pointsToKeepPerMetric = null;

    public Builder() { }

    public Builder(ManagerConfig config) {
      reportPeriodSeconds(config.reportPeriodSeconds());
      pointsToKeepPerMetric(config.pointsToKeepPerMetric());
    }

    private Builder override(Builder __superior) {
      if (__superior.reportPeriodSeconds != null)
        reportPeriodSeconds(__superior.reportPeriodSeconds);
      if (__superior.pointsToKeepPerMetric != null)
        pointsToKeepPerMetric(__superior.pointsToKeepPerMetric);
      return this;
    }

    public Builder reportPeriodSeconds(int __value) {
      reportPeriodSeconds = __value;
      return this;
    }

    private Builder reportPeriodSeconds(String __value) {
      return reportPeriodSeconds(Integer.valueOf(__value));
    }

    public Builder pointsToKeepPerMetric(int __value) {
      pointsToKeepPerMetric = __value;
      return this;
    }

    private Builder pointsToKeepPerMetric(String __value) {
      return pointsToKeepPerMetric(Integer.valueOf(__value));
    }

    private boolean _applyOnRestart = false;

    @java.lang.Override
    public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
      if (producer instanceof Producer) {
        ((Producer)producer).getConfig(this);
        return true;
      }
      return false;
    }

    @java.lang.Override
    public final String getDefMd5() { return CONFIG_DEF_MD5; }

    @java.lang.Override
    public final String getDefName() { return CONFIG_DEF_NAME; }

    @java.lang.Override
    public final String getDefNamespace() { return CONFIG_DEF_NAMESPACE; }

    @java.lang.Override
    public final boolean getApplyOnRestart() { return _applyOnRestart; }

    @java.lang.Override
    public final void setApplyOnRestart(boolean applyOnRestart) { _applyOnRestart = applyOnRestart; }

    public ManagerConfig build() {
      return new ManagerConfig(this);
    }

  }

  private final IntegerNode reportPeriodSeconds;
  private final IntegerNode pointsToKeepPerMetric;

  public ManagerConfig(Builder builder) {
    this(builder, true);
  }

  private ManagerConfig(Builder builder, boolean throwIfUninitialized) {
    if (throwIfUninitialized && ! builder.__uninitialized.isEmpty())
      throw new IllegalArgumentException("The following builder parameters for " +
          "manager must be initialized: " + builder.__uninitialized);

    reportPeriodSeconds = (builder.reportPeriodSeconds == null) ?
        new IntegerNode(60) : new IntegerNode(builder.reportPeriodSeconds);
    pointsToKeepPerMetric = (builder.pointsToKeepPerMetric == null) ?
        new IntegerNode(100) : new IntegerNode(builder.pointsToKeepPerMetric);
  }

  /**
   * @return manager.reportPeriodSeconds
   */
  public int reportPeriodSeconds() {
    return reportPeriodSeconds.value();
  }

  /**
   * @return manager.pointsToKeepPerMetric
   */
  public int pointsToKeepPerMetric() {
    return pointsToKeepPerMetric.value();
  }

  private ChangesRequiringRestart getChangesRequiringRestart(ManagerConfig newConfig) {
    ChangesRequiringRestart changes = new ChangesRequiringRestart("manager");
    return changes;
  }

  private static boolean containsFieldsFlaggedWithRestart() {
    return false;
  }


}
