/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.content;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.Node;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class LoadTypeConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "d05d64950b5e21ee32a19fd88de62dd6";
    public static final String CONFIG_DEF_NAME = "load-type";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.content";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.content", "type[].id int restart", "type[].name string restart", "type[].priority string restart"};
    private final InnerNodeVector<Type> type;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public LoadTypeConfig(Builder builder) {
        this(builder, true);
    }

    private LoadTypeConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for load-type must be initialized: " + String.valueOf(builder.__uninitialized));
        }
        this.type = Type.createVector(builder.type);
    }

    public List<Type> type() {
        return this.type;
    }

    public Type type(int i) {
        return (Type)((Object)this.type.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(LoadTypeConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        changes.compareArray(this.type, newConfig.type, "type", "", (a, b) -> ((Type)a).getChangesRequiringRestart((Type)b));
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return true;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public List<Type.Builder> type = new ArrayList<Type.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(LoadTypeConfig config) {
            for (Type t : config.type()) {
                this.type(new Type.Builder(t));
            }
        }

        private Builder override(Builder __superior) {
            if (!__superior.type.isEmpty()) {
                this.type.addAll(__superior.type);
            }
            return this;
        }

        public Builder type(Type.Builder __builder) {
            this.type.add(__builder);
            return this;
        }

        public Builder type(Consumer<Type.Builder> __func) {
            Type.Builder __inner = new Type.Builder();
            __func.accept(__inner);
            this.type.add(__inner);
            return this;
        }

        public Builder type(List<Type.Builder> __builders) {
            this.type = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return LoadTypeConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return LoadTypeConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return LoadTypeConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public LoadTypeConfig build() {
            return new LoadTypeConfig(this);
        }
    }

    public static final class Type
    extends InnerNode {
        private final IntegerNode id;
        private final StringNode name;
        private final StringNode priority;

        public Type(Builder builder) {
            this(builder, true);
        }

        private Type(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for load-type.type[] must be initialized: " + String.valueOf(builder.__uninitialized));
            }
            this.id = builder.id == null ? new IntegerNode() : new IntegerNode(builder.id.intValue());
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.priority = builder.priority == null ? new StringNode() : new StringNode(builder.priority);
        }

        public int id() {
            return this.id.value();
        }

        public String name() {
            return this.name.value();
        }

        public String priority() {
            return this.priority.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Type newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("type");
            changes.compare((Node)this.id, (Node)newConfig.id, "id", "The identifying index of this type. 0 cannot be used as it is\nreserved for the default type. Other types should be\nnon-overlapping from 1 and upwards. No gaps are allowed in the\nindex range. (For performance reasons we want to use arrays\ninternally where the id is the index)\n \nThe identifier is used for efficient transfer of type information.\nThe types will be identified by names instead in more textual or\nverbose interfaces.\nrestart flag was added automatically and needs to be verified.");
            changes.compare((Node)this.name, (Node)newConfig.name, "name", "The name of a given load type. Each load type must have a unique\nname. The name \"default\" is reserved for the default type of id 0.\nrestart flag was added automatically and needs to be verified.");
            changes.compare((Node)this.priority, (Node)newConfig.priority, "priority", "The default priority for the load type.\nrestart flag was added automatically and needs to be verified.");
            return changes;
        }

        private static InnerNodeVector<Type> createVector(List<Builder> builders) {
            ArrayList<Type> elems = new ArrayList<Type>();
            for (Builder b : builders) {
                elems.add(new Type(b));
            }
            return new InnerNodeVector(elems);
        }

        public static final class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(List.of("id", "name", "priority"));
            private Integer id = null;
            private String name = null;
            private String priority = null;

            public Builder() {
            }

            public Builder(Type config) {
                this.id(config.id());
                this.name(config.name());
                this.priority(config.priority());
            }

            private Builder override(Builder __superior) {
                if (__superior.id != null) {
                    this.id(__superior.id);
                }
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.priority != null) {
                    this.priority(__superior.priority);
                }
                return this;
            }

            public Builder id(int __value) {
                this.id = __value;
                this.__uninitialized.remove("id");
                return this;
            }

            private Builder id(String __value) {
                return this.id(Integer.valueOf(__value));
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder priority(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.priority = __value;
                this.__uninitialized.remove("priority");
                return this;
            }

            public Type build() {
                return new Type(this);
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

