/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.cloud.config;

import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.LeafNode;
import com.yahoo.config.LeafNodeVector;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class OpenTelemetryConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "7ca00a9409bc0071551d4f0335adacae";
    public static final String CONFIG_DEF_NAME = "open-telemetry";
    public static final String CONFIG_DEF_NAMESPACE = "cloud.config";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=cloud.config", "yaml string", "refPaths[] string"};
    private final StringNode yaml;
    private final LeafNodeVector<String, StringNode> refPaths;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public OpenTelemetryConfig(Builder builder) {
        this(builder, true);
    }

    private OpenTelemetryConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for open-telemetry must be initialized: " + builder.__uninitialized);
        }
        this.yaml = builder.yaml == null ? new StringNode() : new StringNode(builder.yaml);
        this.refPaths = new LeafNodeVector(builder.refPaths, (LeafNode)new StringNode());
    }

    public String yaml() {
        return this.yaml.value();
    }

    public List<String> refPaths() {
        return this.refPaths.asList();
    }

    public String refPaths(int i) {
        return ((StringNode)this.refPaths.get(i)).value();
    }

    private ChangesRequiringRestart getChangesRequiringRestart(OpenTelemetryConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static final class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>(List.of("yaml"));
        private String yaml = null;
        public List<String> refPaths = new ArrayList<String>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(OpenTelemetryConfig config) {
            this.yaml(config.yaml());
            this.refPaths(config.refPaths());
        }

        private Builder override(Builder __superior) {
            if (__superior.yaml != null) {
                this.yaml(__superior.yaml);
            }
            if (!__superior.refPaths.isEmpty()) {
                this.refPaths.addAll(__superior.refPaths);
            }
            return this;
        }

        public Builder yaml(String __value) {
            if (__value == null) {
                throw new IllegalArgumentException("Null value is not allowed.");
            }
            this.yaml = __value;
            this.__uninitialized.remove("yaml");
            return this;
        }

        public Builder refPaths(String __value) {
            this.refPaths.add(__value);
            return this;
        }

        public Builder refPaths(Collection<String> __values) {
            this.refPaths.addAll(__values);
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return OpenTelemetryConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return OpenTelemetryConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return OpenTelemetryConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public OpenTelemetryConfig build() {
            return new OpenTelemetryConfig(this);
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

