/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config.search.core;

import com.yahoo.config.BooleanNode;
import com.yahoo.config.ChangesRequiringRestart;
import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.FileNode;
import com.yahoo.config.FileReference;
import com.yahoo.config.InnerNode;
import com.yahoo.config.InnerNodeVector;
import com.yahoo.config.IntegerNode;
import com.yahoo.config.StringNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public final class OnnxModelsConfig
extends ConfigInstance {
    public static final String CONFIG_DEF_MD5 = "9913a57d64b34a429d24117926c02b1e";
    public static final String CONFIG_DEF_NAME = "onnx-models";
    public static final String CONFIG_DEF_NAMESPACE = "vespa.config.search.core";
    public static final String[] CONFIG_DEF_SCHEMA = new String[]{"namespace=vespa.config.search.core", "gpu.count int default=-1", "model[].name string", "model[].fileref file", "model[].input[].name string", "model[].input[].source string", "model[].output[].name string", "model[].output[].as string", "model[].dry_run_on_setup bool default=false", "model[].stateless_execution_mode string default=\"\"", "model[].stateless_interop_threads int default=-1", "model[].stateless_intraop_threads int default=-1", "model[].gpu_device int default=-1", "model[].gpu_device_required bool default=false"};
    private final Gpu gpu;
    private final InnerNodeVector<Model> model;

    public static String getDefMd5() {
        return CONFIG_DEF_MD5;
    }

    public static String getDefName() {
        return CONFIG_DEF_NAME;
    }

    public static String getDefNamespace() {
        return CONFIG_DEF_NAMESPACE;
    }

    public OnnxModelsConfig(Builder builder) {
        this(builder, true);
    }

    private OnnxModelsConfig(Builder builder, boolean throwIfUninitialized) {
        if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
            throw new IllegalArgumentException("The following builder parameters for onnx-models must be initialized: " + builder.__uninitialized);
        }
        this.gpu = new Gpu(builder.gpu, throwIfUninitialized);
        this.model = Model.createVector(builder.model);
    }

    public Gpu gpu() {
        return this.gpu;
    }

    public List<Model> model() {
        return this.model;
    }

    public Model model(int i) {
        return (Model)((Object)this.model.get(i));
    }

    private ChangesRequiringRestart getChangesRequiringRestart(OnnxModelsConfig newConfig) {
        ChangesRequiringRestart changes = new ChangesRequiringRestart(CONFIG_DEF_NAME);
        return changes;
    }

    private static boolean containsFieldsFlaggedWithRestart() {
        return false;
    }

    public static class Builder
    implements ConfigInstance.Builder {
        private Set<String> __uninitialized = new HashSet<String>();
        public Gpu.Builder gpu = new Gpu.Builder();
        public List<Model.Builder> model = new ArrayList<Model.Builder>();
        private boolean _applyOnRestart = false;

        public Builder() {
        }

        public Builder(OnnxModelsConfig config) {
            this.gpu(new Gpu.Builder(config.gpu()));
            for (Model m : config.model()) {
                this.model(new Model.Builder(m));
            }
        }

        private Builder override(Builder __superior) {
            this.gpu(this.gpu.override(__superior.gpu));
            if (!__superior.model.isEmpty()) {
                this.model.addAll(__superior.model);
            }
            return this;
        }

        public Builder gpu(Gpu.Builder __builder) {
            this.gpu = __builder;
            return this;
        }

        public Builder gpu(Consumer<Gpu.Builder> __func) {
            Gpu.Builder __inner = new Gpu.Builder();
            __func.accept(__inner);
            this.gpu = __inner;
            return this;
        }

        public Builder model(Model.Builder __builder) {
            this.model.add(__builder);
            return this;
        }

        public Builder model(Consumer<Model.Builder> __func) {
            Model.Builder __inner = new Model.Builder();
            __func.accept(__inner);
            this.model.add(__inner);
            return this;
        }

        public Builder model(List<Model.Builder> __builders) {
            this.model = __builders;
            return this;
        }

        public final boolean dispatchGetConfig(ConfigInstance.Producer producer) {
            if (producer instanceof Producer) {
                ((Producer)producer).getConfig(this);
                return true;
            }
            return false;
        }

        public final String getDefMd5() {
            return OnnxModelsConfig.CONFIG_DEF_MD5;
        }

        public final String getDefName() {
            return OnnxModelsConfig.CONFIG_DEF_NAME;
        }

        public final String getDefNamespace() {
            return OnnxModelsConfig.CONFIG_DEF_NAMESPACE;
        }

        public final boolean getApplyOnRestart() {
            return this._applyOnRestart;
        }

        public final void setApplyOnRestart(boolean applyOnRestart) {
            this._applyOnRestart = applyOnRestart;
        }

        public OnnxModelsConfig build() {
            return new OnnxModelsConfig(this);
        }
    }

    public static final class Gpu
    extends InnerNode {
        private final IntegerNode count;

        public Gpu(Builder builder) {
            this(builder, true);
        }

        private Gpu(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for onnx-models.gpu must be initialized: " + builder.__uninitialized);
            }
            this.count = builder.count == null ? new IntegerNode(-1) : new IntegerNode(builder.count.intValue());
        }

        public int count() {
            return this.count.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Gpu newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("gpu");
            return changes;
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>();
            private Integer count = null;

            public Builder() {
            }

            public Builder(Gpu config) {
                this.count(config.count());
            }

            private Builder override(Builder __superior) {
                if (__superior.count != null) {
                    this.count(__superior.count);
                }
                return this;
            }

            public Builder count(int __value) {
                this.count = __value;
                return this;
            }

            private Builder count(String __value) {
                return this.count(Integer.valueOf(__value));
            }

            public Gpu build() {
                return new Gpu(this);
            }
        }
    }

    public static final class Model
    extends InnerNode {
        private final StringNode name;
        private final FileNode fileref;
        private final InnerNodeVector<Input> input;
        private final InnerNodeVector<Output> output;
        private final BooleanNode dry_run_on_setup;
        private final StringNode stateless_execution_mode;
        private final IntegerNode stateless_interop_threads;
        private final IntegerNode stateless_intraop_threads;
        private final IntegerNode gpu_device;
        private final BooleanNode gpu_device_required;

        public Model(Builder builder) {
            this(builder, true);
        }

        private Model(Builder builder, boolean throwIfUninitialized) {
            if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                throw new IllegalArgumentException("The following builder parameters for onnx-models.model[] must be initialized: " + builder.__uninitialized);
            }
            this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
            this.fileref = builder.fileref == null ? new FileNode() : new FileNode(builder.fileref);
            this.input = Input.createVector(builder.input);
            this.output = Output.createVector(builder.output);
            this.dry_run_on_setup = builder.dry_run_on_setup == null ? new BooleanNode(false) : new BooleanNode(builder.dry_run_on_setup.booleanValue());
            this.stateless_execution_mode = builder.stateless_execution_mode == null ? new StringNode("") : new StringNode(builder.stateless_execution_mode);
            this.stateless_interop_threads = builder.stateless_interop_threads == null ? new IntegerNode(-1) : new IntegerNode(builder.stateless_interop_threads.intValue());
            this.stateless_intraop_threads = builder.stateless_intraop_threads == null ? new IntegerNode(-1) : new IntegerNode(builder.stateless_intraop_threads.intValue());
            this.gpu_device = builder.gpu_device == null ? new IntegerNode(-1) : new IntegerNode(builder.gpu_device.intValue());
            this.gpu_device_required = builder.gpu_device_required == null ? new BooleanNode(false) : new BooleanNode(builder.gpu_device_required.booleanValue());
        }

        public String name() {
            return this.name.value();
        }

        public FileReference fileref() {
            return this.fileref.value();
        }

        public List<Input> input() {
            return this.input;
        }

        public Input input(int i) {
            return (Input)((Object)this.input.get(i));
        }

        public List<Output> output() {
            return this.output;
        }

        public Output output(int i) {
            return (Output)((Object)this.output.get(i));
        }

        public boolean dry_run_on_setup() {
            return this.dry_run_on_setup.value();
        }

        public String stateless_execution_mode() {
            return this.stateless_execution_mode.value();
        }

        public int stateless_interop_threads() {
            return this.stateless_interop_threads.value();
        }

        public int stateless_intraop_threads() {
            return this.stateless_intraop_threads.value();
        }

        public int gpu_device() {
            return this.gpu_device.value();
        }

        public boolean gpu_device_required() {
            return this.gpu_device_required.value();
        }

        private ChangesRequiringRestart getChangesRequiringRestart(Model newConfig) {
            ChangesRequiringRestart changes = new ChangesRequiringRestart("model");
            return changes;
        }

        private static InnerNodeVector<Model> createVector(List<Builder> builders) {
            ArrayList<Model> elems = new ArrayList<Model>();
            for (Builder b : builders) {
                elems.add(new Model(b));
            }
            return new InnerNodeVector(elems);
        }

        public static class Builder
        implements ConfigBuilder {
            private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name", "fileref"));
            private String name = null;
            private String fileref = null;
            public List<Input.Builder> input = new ArrayList<Input.Builder>();
            public List<Output.Builder> output = new ArrayList<Output.Builder>();
            private Boolean dry_run_on_setup = null;
            private String stateless_execution_mode = null;
            private Integer stateless_interop_threads = null;
            private Integer stateless_intraop_threads = null;
            private Integer gpu_device = null;
            private Boolean gpu_device_required = null;

            public Builder() {
            }

            public Builder(Model config) {
                this.name(config.name());
                this.fileref(config.fileref().value());
                for (Input i : config.input()) {
                    this.input(new Input.Builder(i));
                }
                for (Output o : config.output()) {
                    this.output(new Output.Builder(o));
                }
                this.dry_run_on_setup(config.dry_run_on_setup());
                this.stateless_execution_mode(config.stateless_execution_mode());
                this.stateless_interop_threads(config.stateless_interop_threads());
                this.stateless_intraop_threads(config.stateless_intraop_threads());
                this.gpu_device(config.gpu_device());
                this.gpu_device_required(config.gpu_device_required());
            }

            private Builder override(Builder __superior) {
                if (__superior.name != null) {
                    this.name(__superior.name);
                }
                if (__superior.fileref != null) {
                    this.fileref(__superior.fileref);
                }
                if (!__superior.input.isEmpty()) {
                    this.input.addAll(__superior.input);
                }
                if (!__superior.output.isEmpty()) {
                    this.output.addAll(__superior.output);
                }
                if (__superior.dry_run_on_setup != null) {
                    this.dry_run_on_setup(__superior.dry_run_on_setup);
                }
                if (__superior.stateless_execution_mode != null) {
                    this.stateless_execution_mode(__superior.stateless_execution_mode);
                }
                if (__superior.stateless_interop_threads != null) {
                    this.stateless_interop_threads(__superior.stateless_interop_threads);
                }
                if (__superior.stateless_intraop_threads != null) {
                    this.stateless_intraop_threads(__superior.stateless_intraop_threads);
                }
                if (__superior.gpu_device != null) {
                    this.gpu_device(__superior.gpu_device);
                }
                if (__superior.gpu_device_required != null) {
                    this.gpu_device_required(__superior.gpu_device_required);
                }
                return this;
            }

            public Builder name(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.name = __value;
                this.__uninitialized.remove("name");
                return this;
            }

            public Builder fileref(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.fileref = __value;
                this.__uninitialized.remove("fileref");
                return this;
            }

            public Builder input(Input.Builder __builder) {
                this.input.add(__builder);
                return this;
            }

            public Builder input(Consumer<Input.Builder> __func) {
                Input.Builder __inner = new Input.Builder();
                __func.accept(__inner);
                this.input.add(__inner);
                return this;
            }

            public Builder input(List<Input.Builder> __builders) {
                this.input = __builders;
                return this;
            }

            public Builder output(Output.Builder __builder) {
                this.output.add(__builder);
                return this;
            }

            public Builder output(Consumer<Output.Builder> __func) {
                Output.Builder __inner = new Output.Builder();
                __func.accept(__inner);
                this.output.add(__inner);
                return this;
            }

            public Builder output(List<Output.Builder> __builders) {
                this.output = __builders;
                return this;
            }

            public Builder dry_run_on_setup(boolean __value) {
                this.dry_run_on_setup = __value;
                return this;
            }

            private Builder dry_run_on_setup(String __value) {
                return this.dry_run_on_setup(Boolean.valueOf(__value));
            }

            public Builder stateless_execution_mode(String __value) {
                if (__value == null) {
                    throw new IllegalArgumentException("Null value is not allowed.");
                }
                this.stateless_execution_mode = __value;
                return this;
            }

            public Builder stateless_interop_threads(int __value) {
                this.stateless_interop_threads = __value;
                return this;
            }

            private Builder stateless_interop_threads(String __value) {
                return this.stateless_interop_threads(Integer.valueOf(__value));
            }

            public Builder stateless_intraop_threads(int __value) {
                this.stateless_intraop_threads = __value;
                return this;
            }

            private Builder stateless_intraop_threads(String __value) {
                return this.stateless_intraop_threads(Integer.valueOf(__value));
            }

            public Builder gpu_device(int __value) {
                this.gpu_device = __value;
                return this;
            }

            private Builder gpu_device(String __value) {
                return this.gpu_device(Integer.valueOf(__value));
            }

            public Builder gpu_device_required(boolean __value) {
                this.gpu_device_required = __value;
                return this;
            }

            private Builder gpu_device_required(String __value) {
                return this.gpu_device_required(Boolean.valueOf(__value));
            }

            public Model build() {
                return new Model(this);
            }
        }

        public static final class Input
        extends InnerNode {
            private final StringNode name;
            private final StringNode source;

            public Input(Builder builder) {
                this(builder, true);
            }

            private Input(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for onnx-models.model[].input[] must be initialized: " + builder.__uninitialized);
                }
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                this.source = builder.source == null ? new StringNode() : new StringNode(builder.source);
            }

            public String name() {
                return this.name.value();
            }

            public String source() {
                return this.source.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Input newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("input");
                return changes;
            }

            private static InnerNodeVector<Input> createVector(List<Builder> builders) {
                ArrayList<Input> elems = new ArrayList<Input>();
                for (Builder b : builders) {
                    elems.add(new Input(b));
                }
                return new InnerNodeVector(elems);
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name", "source"));
                private String name = null;
                private String source = null;

                public Builder() {
                }

                public Builder(Input config) {
                    this.name(config.name());
                    this.source(config.source());
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (__superior.source != null) {
                        this.source(__superior.source);
                    }
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Builder source(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.source = __value;
                    this.__uninitialized.remove("source");
                    return this;
                }

                public Input build() {
                    return new Input(this);
                }
            }
        }

        public static final class Output
        extends InnerNode {
            private final StringNode name;
            private final StringNode as;

            public Output(Builder builder) {
                this(builder, true);
            }

            private Output(Builder builder, boolean throwIfUninitialized) {
                if (throwIfUninitialized && !builder.__uninitialized.isEmpty()) {
                    throw new IllegalArgumentException("The following builder parameters for onnx-models.model[].output[] must be initialized: " + builder.__uninitialized);
                }
                this.name = builder.name == null ? new StringNode() : new StringNode(builder.name);
                this.as = builder.as == null ? new StringNode() : new StringNode(builder.as);
            }

            public String name() {
                return this.name.value();
            }

            public String as() {
                return this.as.value();
            }

            private ChangesRequiringRestart getChangesRequiringRestart(Output newConfig) {
                ChangesRequiringRestart changes = new ChangesRequiringRestart("output");
                return changes;
            }

            private static InnerNodeVector<Output> createVector(List<Builder> builders) {
                ArrayList<Output> elems = new ArrayList<Output>();
                for (Builder b : builders) {
                    elems.add(new Output(b));
                }
                return new InnerNodeVector(elems);
            }

            public static class Builder
            implements ConfigBuilder {
                private Set<String> __uninitialized = new HashSet<String>(Arrays.asList("name", "as"));
                private String name = null;
                private String as = null;

                public Builder() {
                }

                public Builder(Output config) {
                    this.name(config.name());
                    this.as(config.as());
                }

                private Builder override(Builder __superior) {
                    if (__superior.name != null) {
                        this.name(__superior.name);
                    }
                    if (__superior.as != null) {
                        this.as(__superior.as);
                    }
                    return this;
                }

                public Builder name(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.name = __value;
                    this.__uninitialized.remove("name");
                    return this;
                }

                public Builder as(String __value) {
                    if (__value == null) {
                        throw new IllegalArgumentException("Null value is not allowed.");
                    }
                    this.as = __value;
                    this.__uninitialized.remove("as");
                    return this;
                }

                public Output build() {
                    return new Output(this);
                }
            }
        }
    }

    public static interface Producer
    extends ConfigInstance.Producer {
        public void getConfig(Builder var1);
    }
}

