/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.config;

import com.yahoo.compress.CompressionType;
import com.yahoo.compress.Compressor;
import java.nio.ByteBuffer;

public class LZ4PayloadCompressor {
    private static final Compressor compressor = new Compressor(CompressionType.LZ4, 0);

    public byte[] compress(byte[] input) {
        return compressor.compressUnconditionally(input);
    }

    public byte[] compress(ByteBuffer input) {
        return compressor.compressUnconditionally(input);
    }

    public byte[] decompress(byte[] input, int uncompressedLen) {
        return compressor.decompressUnconditionally(input, 0, uncompressedLen);
    }

    public byte[] decompress(ByteBuffer input, int uncompressedLen) {
        ByteBuffer uncompressed = ByteBuffer.allocate(uncompressedLen);
        compressor.decompressUnconditionally(input, uncompressed);
        return uncompressed.array();
    }
}

