/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription;

import com.yahoo.config.ConfigBuilder;
import com.yahoo.config.ConfigInstance;
import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.ConfigTransformer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ConfigInstanceUtil {
    public static <BUILDER extends ConfigBuilder> void setValues(BUILDER destination, BUILDER source) {
        try {
            Method setter = destination.getClass().getDeclaredMethod("override", destination.getClass());
            setter.setAccessible(true);
            setter.invoke(destination, source);
            setter.setAccessible(false);
        }
        catch (Exception e) {
            throw new ConfigurationRuntimeException("Could not set values on config builder." + destination.getClass().getName(), (Throwable)e);
        }
    }

    public static <T extends ConfigInstance> T getNewInstance(Class<T> type, String configId, ConfigPayload payload) {
        ConfigInstance instance;
        try {
            ConfigTransformer<T> transformer = new ConfigTransformer<T>(type);
            ConfigInstance.Builder instanceBuilder = transformer.toConfigBuilder(payload);
            Constructor<T> constructor = type.getConstructor(instanceBuilder.getClass());
            instance = (ConfigInstance)constructor.newInstance(instanceBuilder);
            instance.postInitialize(configId);
            ConfigInstanceUtil.setConfigId(instance, configId);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Failed creating new instance of '" + type.getCanonicalName() + "' for config id '" + configId + "'", e);
        }
        return (T)instance;
    }

    private static void setConfigId(ConfigInstance instance, String configId) throws NoSuchFieldException, IllegalAccessException {
        Field configIdField = ConfigInstance.class.getDeclaredField("configId");
        configIdField.setAccessible(true);
        configIdField.set(instance, configId);
        configIdField.setAccessible(false);
    }

    public static Object getField(ConfigBuilder builder, String fieldName) {
        try {
            Field f = builder.getClass().getDeclaredField(fieldName);
            f.setAccessible(true);
            return f.get(builder);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

