/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription.impl;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.config.subscription.ConfigInterruptedException;
import com.yahoo.config.subscription.impl.ConfigSubscription;
import com.yahoo.config.subscription.impl.JRTConfigRequester;
import com.yahoo.jrt.Request;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.ConfigPayload;
import com.yahoo.vespa.config.PayloadChecksums;
import com.yahoo.vespa.config.TimingValues;
import com.yahoo.vespa.config.protocol.CompressionType;
import com.yahoo.vespa.config.protocol.DefContent;
import com.yahoo.vespa.config.protocol.JRTClientConfigRequest;
import com.yahoo.vespa.config.protocol.Payload;
import com.yahoo.vespa.config.protocol.Trace;
import com.yahoo.vespa.config.protocol.VespaVersion;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class JRTConfigSubscription<T extends ConfigInstance>
extends ConfigSubscription<T> {
    private final JRTConfigRequester requester;
    private final TimingValues timingValues;
    private Instant lastOK = Instant.MIN;
    private BlockingQueue<JRTClientConfigRequest> responseQueue = new LinkedBlockingQueue<JRTClientConfigRequest>();

    public JRTConfigSubscription(ConfigKey<T> key, JRTConfigRequester requester, TimingValues timingValues) {
        super(key);
        this.timingValues = timingValues;
        this.requester = requester;
    }

    @Override
    public boolean nextConfig(long timeoutMillis) {
        JRTClientConfigRequest response = this.pollForNewConfig(timeoutMillis);
        if (response == null) {
            return this.newConfigOrException();
        }
        log.log(Level.FINE, () -> "Polled queue and found config " + String.valueOf(response));
        if (response.hasUpdatedGeneration()) {
            this.setApplyOnRestart(response.responseIsApplyOnRestart());
            if (response.hasUpdatedConfig()) {
                this.setNewConfig(response);
            } else {
                this.setNewConfigAndGeneration(response);
            }
        }
        return this.newConfigOrException();
    }

    private synchronized JRTClientConfigRequest pollForNewConfig(long timeoutMillis) {
        JRTClientConfigRequest response;
        JRTClientConfigRequest temp = response = this.pollQueue(timeoutMillis);
        while (temp != null) {
            temp = this.pollQueue(0L);
            if (temp == null) continue;
            response = temp;
        }
        return response;
    }

    private boolean newConfigOrException() {
        ConfigSubscription.ConfigState configState = this.getConfigState();
        return configState.isGenerationChanged() || configState.isConfigChanged() || this.hasException();
    }

    private JRTClientConfigRequest pollQueue(long timeoutMillis) {
        try {
            JRTClientConfigRequest request = this.responseQueue.poll(timeoutMillis, TimeUnit.MILLISECONDS);
            return request instanceof EOFJRTClientConfigRequest ? null : request;
        }
        catch (InterruptedException e1) {
            throw new ConfigInterruptedException(e1);
        }
    }

    protected void setNewConfig(JRTClientConfigRequest jrtReq) {
        try {
            T configInstance = this.toConfigInstance(jrtReq);
            this.setConfig(jrtReq.getNewGeneration(), jrtReq.responseIsApplyOnRestart(), configInstance, jrtReq.getNewChecksums());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Bad config in response", e);
        }
    }

    protected void setNewConfigAndGeneration(JRTClientConfigRequest jrtReq) {
        try {
            T configInstance = this.toConfigInstance(jrtReq);
            this.setConfigAndGeneration(jrtReq.getNewGeneration(), jrtReq.responseIsApplyOnRestart(), configInstance, jrtReq.getNewChecksums());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Bad config in response", e);
        }
    }

    private T toConfigInstance(JRTClientConfigRequest jrtRequest) {
        Payload payload = jrtRequest.getNewPayload();
        ConfigPayload configPayload = ConfigPayload.fromUtf8Array(payload.withCompression(CompressionType.UNCOMPRESSED).getData());
        return (T)configPayload.toInstance(this.configClass, jrtRequest.getConfigKey().getConfigId());
    }

    void updateConfig(JRTClientConfigRequest jrtReq) {
        if (!this.responseQueue.offer(jrtReq)) {
            this.setException((RuntimeException)new ConfigurationRuntimeException("Failed offering returned request to queue of subscription " + String.valueOf(this)));
        }
    }

    @Override
    public boolean subscribe(long timeout) {
        this.lastOK = Instant.now();
        this.requester.request(this);
        JRTClientConfigRequest req = (JRTClientConfigRequest)this.responseQueue.peek();
        while (req == null && Instant.now().isBefore(this.lastOK.plus(Duration.ofMillis(timeout)))) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new ConfigInterruptedException(e);
            }
            req = (JRTClientConfigRequest)this.responseQueue.peek();
        }
        return req != null && !(req instanceof EOFJRTClientConfigRequest);
    }

    @Override
    public void close() {
        super.close();
        if (!this.responseQueue.offer(new EOFJRTClientConfigRequest())) {
            this.setException((RuntimeException)new ConfigurationRuntimeException("Failed offering EOF to queue during close() " + String.valueOf(this)));
        }
        this.responseQueue = new LinkedBlockingQueue<JRTClientConfigRequest>(){

            @Override
            public void put(JRTClientConfigRequest e) {
            }
        };
    }

    public TimingValues timingValues() {
        return this.timingValues;
    }

    public JRTConfigRequester requester() {
        return this.requester;
    }

    @Override
    public void reload(long generation) {
        log.log(Level.FINE, "reload() is without effect on a JRTConfigSubscription.");
    }

    void setLastCallBackOKTS(Instant lastCallBackOKTS) {
        this.lastOK = lastCallBackOKTS;
    }

    static void printStatus(JRTClientConfigRequest request, String message) {
        String name = request.getConfigKey().getName();
        if (name.equals("components") || name.equals("chains")) {
            log.log(Level.INFO, message + ":" + name + ":, request=" + String.valueOf(request));
        }
    }

    private static class EOFJRTClientConfigRequest
    implements JRTClientConfigRequest {
        private EOFJRTClientConfigRequest() {
        }

        @Override
        public boolean validateResponse() {
            return false;
        }

        @Override
        public boolean hasUpdatedGeneration() {
            return false;
        }

        @Override
        public Payload getNewPayload() {
            return null;
        }

        @Override
        public JRTClientConfigRequest nextRequest(long timeout) {
            return null;
        }

        @Override
        public boolean isError() {
            return false;
        }

        @Override
        public long getNewGeneration() {
            return 0L;
        }

        @Override
        public boolean responseIsApplyOnRestart() {
            return false;
        }

        @Override
        public PayloadChecksums getNewChecksums() {
            return null;
        }

        @Override
        public boolean hasUpdatedConfig() {
            return false;
        }

        @Override
        public Trace getResponseTrace() {
            return null;
        }

        @Override
        public DefContent getDefContent() {
            return null;
        }

        @Override
        public ConfigKey<?> getConfigKey() {
            return null;
        }

        @Override
        public boolean validateParameters() {
            return false;
        }

        @Override
        public String getRequestDefMd5() {
            return null;
        }

        @Override
        public PayloadChecksums getRequestConfigChecksums() {
            return null;
        }

        @Override
        public long getRequestGeneration() {
            return 0L;
        }

        @Override
        public Request getRequest() {
            return null;
        }

        @Override
        public String getShortDescription() {
            return null;
        }

        @Override
        public int errorCode() {
            return 0;
        }

        @Override
        public String errorMessage() {
            return null;
        }

        @Override
        public long getTimeout() {
            return 0L;
        }

        @Override
        public long getProtocolVersion() {
            return 0L;
        }

        @Override
        public String getClientHostName() {
            return null;
        }

        @Override
        public Optional<VespaVersion> getVespaVersion() {
            return Optional.empty();
        }
    }
}

