/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.subscription.impl;

import com.yahoo.config.ConfigInstance;
import com.yahoo.config.ConfigurationRuntimeException;
import com.yahoo.config.subscription.CfgConfigPayloadBuilder;
import com.yahoo.config.subscription.ConfigInterruptedException;
import com.yahoo.config.subscription.FileSource;
import com.yahoo.config.subscription.impl.ConfigSubscription;
import com.yahoo.vespa.config.ConfigKey;
import com.yahoo.vespa.config.ConfigPayload;
import java.io.IOException;
import java.util.logging.Level;

public class FileConfigSubscription<T extends ConfigInstance>
extends ConfigSubscription<T> {
    final FileSource file;
    long ts;

    FileConfigSubscription(ConfigKey<T> key, FileSource file) {
        super(key);
        file.validateFile();
        this.setGeneration(0L);
        this.file = file;
    }

    @Override
    public boolean nextConfig(long timeout) {
        this.file.validateFile();
        if (this.checkReloaded()) {
            log.log(Level.FINE, () -> "User forced config reload at " + System.currentTimeMillis());
            this.setConfigIfChanged(this.updateConfig());
            ConfigSubscription.ConfigState configState = this.getConfigState();
            log.log(Level.FINE, () -> "Config updated at " + System.currentTimeMillis() + ", changed: " + configState.isConfigChanged());
            log.log(Level.FINE, () -> "Config: " + configState.getConfig().toString());
            return true;
        }
        if (this.file.getLastModified() != this.ts) {
            this.setConfigIncGen(this.updateConfig());
            return true;
        }
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException e) {
            throw new ConfigInterruptedException(e);
        }
        return false;
    }

    private T updateConfig() {
        this.ts = this.file.getLastModified();
        try {
            ConfigPayload payload = new CfgConfigPayloadBuilder().deserialize(this.file.getContent());
            return (T)payload.toInstance(this.configClass, this.key.getConfigId());
        }
        catch (IOException e) {
            throw new ConfigurationRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean subscribe(long timeout) {
        return true;
    }
}

