/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.SidecarResources;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public record SidecarSpec(long id, String name, DockerImage image, SidecarResources resources, List<String> volumeMounts, Map<String, String> envs, List<String> command) {
    public SidecarSpec {
        if (id < 0L || id > 99L) {
            throw new IllegalArgumentException("Sidecar id must be from 0 to 99 inclusive");
        }
        Objects.requireNonNull(name);
        Objects.requireNonNull(image);
        Objects.requireNonNull(volumeMounts);
        Objects.requireNonNull(envs);
        Objects.requireNonNull(command);
    }

    public boolean matchesByIdOrName(SidecarSpec other) {
        return this.id == other.id || this.name.equals(other.name);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SidecarSpec that = (SidecarSpec)o;
        return this.id == that.id && Objects.equals(this.name, that.name) && Objects.equals(this.image, that.image) && Objects.equals(this.resources, that.resources) && Objects.equals(this.volumeMounts, that.volumeMounts) && Objects.equals(this.envs, that.envs) && Objects.equals(this.command, that.command);
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private long id;
        private String name;
        private DockerImage image;
        private SidecarResources resources = new SidecarResources(0.0, 0.0, 0.0, false);
        private List<String> volumeMounts = List.of();
        private Map<String, String> envs = Map.of();
        private List<String> command = List.of();

        public Builder() {
        }

        public Builder(SidecarSpec spec) {
            this.id = spec.id;
            this.name = spec.name;
            this.image = spec.image;
            this.resources = spec.resources;
            this.volumeMounts = spec.volumeMounts;
            this.envs = spec.envs;
            this.command = spec.command;
        }

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder image(DockerImage image) {
            this.image = image;
            return this;
        }

        public Builder resources(SidecarResources resources) {
            this.resources = resources;
            return this;
        }

        public Builder volumeMounts(List<String> volumeMounts) {
            this.volumeMounts = List.copyOf(volumeMounts);
            return this;
        }

        public Builder envs(Map<String, String> envs) {
            this.envs = Map.copyOf(envs);
            return this;
        }

        public Builder command(List<String> command) {
            this.command = List.copyOf(command);
            return this;
        }

        public Builder maxCpu(double maxCpu) {
            this.resources = this.resources.withMaxCpu(maxCpu);
            return this;
        }

        public Builder minCpu(double minCpu) {
            this.resources = this.resources.withMinCpu(minCpu);
            return this;
        }

        public Builder memoryGiB(double memoryGiB) {
            this.resources = this.resources.withMemoryGiB(memoryGiB);
            return this;
        }

        public Builder hasGpu(boolean hasGpu) {
            this.resources = this.resources.withGpu(hasGpu);
            return this;
        }

        public SidecarSpec build() {
            return new SidecarSpec(this.id, this.name, this.image, this.resources, this.volumeMounts, this.envs, this.command);
        }
    }
}

