/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.component.Version;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.SidecarSpec;
import com.yahoo.config.provision.ZoneEndpoint;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ClusterMembership {
    private final ClusterSpec cluster;
    private final int index;
    private final boolean retired;
    private final String stringValue;

    private ClusterMembership(String stringValue, Version vespaVersion, Optional<DockerImage> dockerImageRepo, ZoneEndpoint zoneEndpoint, List<SidecarSpec> sidecars) {
        Integer nodeIndex;
        String[] components = stringValue.split("/");
        if (components.length < 3) {
            throw new RuntimeException("Could not parse '" + stringValue + "' to a cluster membership. Expected 'clusterType/clusterId/groupId/index[/retired][/exclusive][/stateful]'");
        }
        Integer groupIndex = components[2].isEmpty() ? null : Integer.valueOf(Integer.parseInt(components[2]));
        int missingElements = 0;
        try {
            nodeIndex = Integer.parseInt(components[3]);
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            nodeIndex = groupIndex;
            groupIndex = null;
            missingElements = 1;
        }
        boolean exclusive = false;
        boolean stateful = false;
        boolean retired = false;
        if (components.length > 4 - missingElements) {
            block12: for (int i = 4 - missingElements; i < components.length; ++i) {
                String component;
                switch (component = components[i]) {
                    case "exclusive": {
                        exclusive = true;
                        continue block12;
                    }
                    case "retired": {
                        retired = true;
                        continue block12;
                    }
                    case "stateful": {
                        stateful = true;
                    }
                }
            }
        }
        this.cluster = ClusterSpec.specification(ClusterSpec.Type.valueOf(components[0]), ClusterSpec.Id.from(components[1])).group(groupIndex == null ? null : ClusterSpec.Group.from(groupIndex)).vespaVersion(vespaVersion).exclusive(exclusive).dockerImageRepository(dockerImageRepo).loadBalancerSettings(zoneEndpoint).stateful(stateful).sidecars(sidecars).build();
        this.index = nodeIndex;
        this.retired = retired;
        this.stringValue = this.toStringValue();
    }

    private ClusterMembership(ClusterSpec cluster, int index, boolean retired) {
        this.cluster = cluster;
        this.index = index;
        this.retired = retired;
        this.stringValue = this.toStringValue();
    }

    protected String toStringValue() {
        return this.cluster.type().name() + "/" + this.cluster.id().value() + (String)(this.cluster.group().isPresent() ? "/" + this.cluster.group().get().index() : "/") + "/" + this.index + (this.cluster.isExclusive() ? "/exclusive" : "") + (this.retired ? "/retired" : "") + (this.cluster.isStateful() ? "/stateful" : "");
    }

    public ClusterSpec cluster() {
        return this.cluster;
    }

    public int index() {
        return this.index;
    }

    public boolean retired() {
        return this.retired;
    }

    public ClusterMembership retire() {
        return new ClusterMembership(this.cluster, this.index, true);
    }

    public ClusterMembership unretire() {
        return new ClusterMembership(this.cluster, this.index, false);
    }

    public ClusterMembership with(ClusterSpec newCluster) {
        return new ClusterMembership(newCluster, this.index, this.retired);
    }

    public String stringValue() {
        return this.stringValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterMembership that = (ClusterMembership)o;
        return this.index == that.index && this.retired == that.retired && this.cluster.equals(that.cluster) && this.stringValue.equals(that.stringValue);
    }

    public int hashCode() {
        return Objects.hash(this.cluster, this.index, this.retired, this.stringValue);
    }

    public String toString() {
        return this.stringValue();
    }

    public static ClusterMembership from(String stringValue, Version vespaVersion, Optional<DockerImage> dockerImageRepo) {
        return ClusterMembership.from(stringValue, vespaVersion, dockerImageRepo, ZoneEndpoint.defaultEndpoint);
    }

    public static ClusterMembership from(String stringValue, Version vespaVersion, Optional<DockerImage> dockerImageRepo, ZoneEndpoint zoneEndpoint) {
        return new ClusterMembership(stringValue, vespaVersion, dockerImageRepo, zoneEndpoint, List.of());
    }

    public static ClusterMembership from(String stringValue, Version vespaVersion, Optional<DockerImage> dockerImageRepo, List<SidecarSpec> sidecars) {
        return ClusterMembership.from(stringValue, vespaVersion, dockerImageRepo, ZoneEndpoint.defaultEndpoint, sidecars);
    }

    public static ClusterMembership from(String stringValue, Version vespaVersion, Optional<DockerImage> dockerImageRepo, ZoneEndpoint zoneEndpoint, List<SidecarSpec> sidecars) {
        return new ClusterMembership(stringValue, vespaVersion, dockerImageRepo, zoneEndpoint, sidecars);
    }

    public static ClusterMembership from(ClusterSpec cluster, int index) {
        return new ClusterMembership(cluster, index, false);
    }

    public static ClusterMembership retiredFrom(ClusterSpec cluster, int index) {
        return new ClusterMembership(cluster, index, true);
    }
}

