/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.component.Version;
import com.yahoo.config.provision.DockerImage;
import com.yahoo.config.provision.ZoneEndpoint;
import java.util.Objects;
import java.util.Optional;

public final class ClusterSpec {
    private final Type type;
    private final Id id;
    private final Optional<Group> groupId;
    private final Version vespaVersion;
    private final boolean exclusive;
    private final Optional<DockerImage> dockerImageRepo;
    private final ZoneEndpoint zoneEndpoint;
    private final boolean stateful;

    private ClusterSpec(Type type, Id id, Optional<Group> groupId, Version vespaVersion, boolean exclusive, Optional<DockerImage> dockerImageRepo, ZoneEndpoint zoneEndpoint, boolean stateful) {
        this.type = type;
        this.id = id;
        this.groupId = groupId;
        this.vespaVersion = Objects.requireNonNull(vespaVersion, "vespaVersion cannot be null");
        this.exclusive = exclusive;
        if (dockerImageRepo.isPresent() && dockerImageRepo.get().tag().isPresent()) {
            throw new IllegalArgumentException("dockerImageRepo is not allowed to have a tag");
        }
        this.dockerImageRepo = dockerImageRepo;
        if (type.isContent() && !stateful) {
            throw new IllegalArgumentException("Cluster of type " + String.valueOf((Object)type) + " must be stateful");
        }
        this.zoneEndpoint = Objects.requireNonNull(zoneEndpoint);
        this.stateful = stateful;
    }

    public Type type() {
        return this.type;
    }

    public Id id() {
        return this.id;
    }

    public Optional<DockerImage> dockerImageRepo() {
        return this.dockerImageRepo;
    }

    public Optional<String> dockerImage() {
        return this.dockerImageRepo.map(repo -> repo.withTag(this.vespaVersion).asString());
    }

    public ZoneEndpoint zoneEndpoint() {
        return this.zoneEndpoint;
    }

    public Version vespaVersion() {
        return this.vespaVersion;
    }

    public Optional<Group> group() {
        return this.groupId;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public boolean isStateful() {
        return this.stateful;
    }

    public ClusterSpec with(Optional<Group> newGroup) {
        return new ClusterSpec(this.type, this.id, newGroup, this.vespaVersion, this.exclusive, this.dockerImageRepo, this.zoneEndpoint, this.stateful);
    }

    public ClusterSpec withExclusivity(boolean exclusive) {
        return new ClusterSpec(this.type, this.id, this.groupId, this.vespaVersion, exclusive, this.dockerImageRepo, this.zoneEndpoint, this.stateful);
    }

    public static Builder request(Type type, Id id) {
        return new Builder(type, id);
    }

    public static Builder specification(Type type, Id id) {
        return new Builder(type, id);
    }

    public String toString() {
        return String.valueOf((Object)this.type) + " " + String.valueOf(this.id) + " " + this.groupId.map(group -> String.valueOf(group) + " ").orElse("") + String.valueOf(this.vespaVersion) + this.dockerImageRepo.map(repo -> " " + String.valueOf(repo)).orElse("");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterSpec that = (ClusterSpec)o;
        return this.exclusive == that.exclusive && this.stateful == that.stateful && this.type == that.type && this.id.equals(that.id) && this.groupId.equals(that.groupId) && this.vespaVersion.equals((Object)that.vespaVersion) && this.dockerImageRepo.equals(that.dockerImageRepo) && this.zoneEndpoint.equals(that.zoneEndpoint);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.id, this.groupId, this.vespaVersion, this.exclusive, this.dockerImageRepo, this.zoneEndpoint, this.stateful});
    }

    public boolean satisfies(ClusterSpec other) {
        if (!other.id.equals(this.id)) {
            return false;
        }
        return other.type.equals((Object)this.type);
    }

    public static enum Type {
        admin,
        container,
        content;


        public boolean isContent() {
            return this == content;
        }

        public boolean isContainer() {
            return this == container;
        }

        public static Type from(String typeName) {
            return switch (typeName) {
                case "admin" -> admin;
                case "container" -> container;
                case "content" -> content;
                default -> throw new IllegalArgumentException("Illegal cluster type '" + typeName + "'");
            };
        }
    }

    public static final class Id {
        private final String id;

        public Id(String id) {
            this.id = Objects.requireNonNull(id, "Id cannot be null");
        }

        public static Id from(String id) {
            return new Id(id);
        }

        public String value() {
            return this.id;
        }

        public String toString() {
            return "cluster '" + this.id + "'";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return ((Id)o).id.equals(this.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }

    public static class Builder {
        private final Type type;
        private final Id id;
        private Optional<Group> groupId = Optional.empty();
        private Optional<DockerImage> dockerImageRepo = Optional.empty();
        private Version vespaVersion;
        private boolean exclusive = false;
        private ZoneEndpoint zoneEndpoint = ZoneEndpoint.defaultEndpoint;
        private boolean stateful;

        private Builder(Type type, Id id) {
            this.type = type;
            this.id = id;
            this.stateful = type.isContent();
        }

        public ClusterSpec build() {
            return new ClusterSpec(this.type, this.id, this.groupId, this.vespaVersion, this.exclusive, this.dockerImageRepo, this.zoneEndpoint, this.stateful);
        }

        public Builder group(Group groupId) {
            this.groupId = Optional.ofNullable(groupId);
            return this;
        }

        public Builder vespaVersion(Version vespaVersion) {
            this.vespaVersion = vespaVersion;
            return this;
        }

        public Builder vespaVersion(String vespaVersion) {
            this.vespaVersion = Version.fromString((String)vespaVersion);
            return this;
        }

        public Builder exclusive(boolean exclusive) {
            this.exclusive = exclusive;
            return this;
        }

        public Builder dockerImageRepository(Optional<DockerImage> dockerImageRepo) {
            this.dockerImageRepo = dockerImageRepo;
            return this;
        }

        public Builder loadBalancerSettings(ZoneEndpoint zoneEndpoint) {
            this.zoneEndpoint = zoneEndpoint;
            return this;
        }

        public Builder stateful(boolean stateful) {
            this.stateful = stateful;
            return this;
        }
    }

    public static final class Group {
        private final int index;

        private Group(int index) {
            this.index = index;
        }

        public static Group from(int index) {
            return new Group(index);
        }

        public int index() {
            return this.index;
        }

        public String toString() {
            return "group " + this.index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return ((Group)o).index == this.index;
        }

        public int hashCode() {
            return this.index;
        }
    }
}

