/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.component.Version;
import com.yahoo.config.provision.ApplicationId;
import com.yahoo.config.provision.Capacity;
import com.yahoo.config.provision.CloudName;
import com.yahoo.config.provision.ClusterResources;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.config.provision.Environment;
import com.yahoo.config.provision.Exclusivity;
import com.yahoo.config.provision.IntRange;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.config.provision.Zone;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CapacityPolicies {
    private static final Logger log = Logger.getLogger(CapacityPolicies.class.getName());
    private static final NodeResources MIN_KUBERNETES_RESOURCES = new NodeResources(0.5, 1.0, 10.0, 0.3);
    private final Zone zone;
    private final Exclusivity exclusivity;
    private final ApplicationId applicationId;
    private final Tuning tuning;

    public CapacityPolicies(Zone zone, Exclusivity exclusivity, ApplicationId applicationId, NodeResources.Architecture adminClusterArchitecture) {
        this(zone, exclusivity, applicationId, new Tuning(adminClusterArchitecture, 0.0, 0.0, 0L));
    }

    public CapacityPolicies(Zone zone, Exclusivity exclusivity, ApplicationId applicationId, Tuning tuning) {
        this.zone = zone;
        this.exclusivity = exclusivity;
        this.applicationId = applicationId;
        this.tuning = tuning;
    }

    public Capacity applyOn(Capacity capacity, boolean exclusive) {
        ClusterResources min = this.applyOn(capacity.minResources(), capacity, exclusive);
        ClusterResources max = this.applyOn(capacity.maxResources(), capacity, exclusive);
        IntRange groupSize = capacity.groupSize().fromAtMost(max.nodes() / min.groups()).toAtLeast(min.nodes() / max.groups());
        return capacity.withLimits(min, max, groupSize);
    }

    private ClusterResources applyOn(ClusterResources resources, Capacity capacity, boolean exclusive) {
        int nodes = this.decideCount(resources.nodes(), capacity.isRequired(), this.applicationId.instance().isTester());
        int groups = this.decideGroups(resources.nodes(), resources.groups(), nodes);
        NodeResources nodeResources = this.decideNodeResources(resources.nodeResources(), capacity.isRequired(), exclusive);
        return new ClusterResources(nodes, groups, nodeResources);
    }

    private int decideCount(int requested, boolean required, boolean isTester) {
        if (isTester) {
            return 1;
        }
        if (required) {
            return requested;
        }
        return switch (this.zone.environment()) {
            default -> throw new IncompatibleClassChangeError();
            case Environment.dev, Environment.test -> 1;
            case Environment.perf -> Math.min(requested, 3);
            case Environment.staging -> {
                if (requested <= 1) {
                    yield requested;
                }
                yield Math.max(2, (int)(0.05 * (double)requested));
            }
            case Environment.prod -> requested;
        };
    }

    private int decideGroups(int requestedNodes, int requestedGroups, int decidedNodes) {
        int groups;
        if (requestedNodes == decidedNodes) {
            return requestedGroups;
        }
        for (groups = Math.min(requestedGroups, decidedNodes); groups > 1 && decidedNodes % groups != 0; --groups) {
        }
        return groups;
    }

    private NodeResources decideNodeResources(NodeResources target, boolean required, boolean exclusive) {
        if (required || exclusive) {
            return target;
        }
        if (target.isUnspecified()) {
            return target;
        }
        if (this.zone.environment() == Environment.dev && this.zone.cloud().allowHostSharing()) {
            target = target.withVcpu(0.1).withBandwidthGbps(0.1);
            target = target.with(NodeResources.GpuResources.zero());
        }
        if (this.zone.system().isCd() || this.zone.environment() == Environment.dev || this.zone.environment() == Environment.test) {
            target = target.with(NodeResources.DiskSpeed.any).with(NodeResources.StorageType.any).withBandwidthGbps(0.1);
        }
        return target;
    }

    public ClusterResources specifyFully(ClusterResources resources, ClusterSpec clusterSpec) {
        return resources.with(this.specifyFully(resources.nodeResources(), clusterSpec));
    }

    public NodeResources specifyFully(NodeResources resources, ClusterSpec clusterSpec) {
        return resources.withUnspecifiedFieldsFrom(this.defaultResources(clusterSpec).with(NodeResources.DiskSpeed.any));
    }

    private NodeResources defaultResources(ClusterSpec clusterSpec) {
        NodeResources.Architecture adminClusterArchitecture = this.tuning.adminClusterArchitecture();
        if (clusterSpec.type() == ClusterSpec.Type.admin) {
            if (this.exclusivity.allocation(clusterSpec) && !this.zone.system().isKubernetes()) {
                return this.smallestExclusiveResources().with(adminClusterArchitecture);
            }
            if (clusterSpec.id().value().equals("cluster-controllers")) {
                return this.clusterControllerResources(clusterSpec, adminClusterArchitecture, this.tuning.contentNodes()).with(adminClusterArchitecture);
            }
            if (clusterSpec.id().value().equals("logserver")) {
                return this.logserverResources(adminClusterArchitecture).with(adminClusterArchitecture);
            }
            return CapacityPolicies.versioned(clusterSpec, Map.of(new Version(0), this.smallestSharedResources())).with(adminClusterArchitecture);
        }
        if (clusterSpec.type() == ClusterSpec.Type.content) {
            return this.zone.cloud().dynamicProvisioning() ? CapacityPolicies.versioned(clusterSpec, Map.of(new Version(0), new NodeResources(2.0, 16.0, 300.0, 0.3))) : CapacityPolicies.versioned(clusterSpec, Map.of(new Version(0), new NodeResources(1.5, 8.0, 50.0, 0.3)));
        }
        return this.zone.cloud().dynamicProvisioning() ? CapacityPolicies.versioned(clusterSpec, Map.of(new Version(0), new NodeResources(2.0, 8.0, 50.0, 0.3))) : CapacityPolicies.versioned(clusterSpec, Map.of(new Version(0), new NodeResources(1.5, 8.0, 50.0, 0.3)));
    }

    private NodeResources clusterControllerResources(ClusterSpec clusterSpec, NodeResources.Architecture architecture, long contentNodes) {
        double memory = architecture == NodeResources.Architecture.x86_64 ? this.tuning.clusterControllerMem(1.32) : this.tuning.clusterControllerMem(1.5);
        double adjustedMemory = CapacityPolicies.adjustClusterControllerMemory(memory, contentNodes);
        if (this.tuning.clusterControllerMemoryGiB() > 0.0) {
            adjustedMemory = memory;
        }
        return CapacityPolicies.versioned(clusterSpec, Map.of(new Version(0), new NodeResources(0.25, memory, 10.0, 0.3), new Version(8, 575, 8), new NodeResources(0.25, adjustedMemory, 10.0, 0.3)));
    }

    private static double adjustClusterControllerMemory(double memory, long nodeCount) {
        int count = (int)nodeCount;
        double adjustment = CapacityPolicies.isBetween(count, 0, 50) ? 0.0 : (CapacityPolicies.isBetween(count, 50, 100) ? 0.15 : (CapacityPolicies.isBetween(count, 100, 200) ? 0.3 : (CapacityPolicies.isBetween(count, 200, 300) ? 0.45 : 0.6)));
        double newMemory = memory + adjustment;
        if (count >= 50) {
            log.log(Level.INFO, "Adjusted cluster controller memory (" + count + " content nodes): " + newMemory + " GiB");
        } else {
            log.log(Level.FINE, "Not adjusting cluster controller memory (" + count + " content nodes): " + newMemory + " GiB");
        }
        return newMemory;
    }

    public static boolean isBetween(int x, int lower, int upper) {
        return lower <= x && x < upper;
    }

    private NodeResources logserverResources(NodeResources.Architecture architecture) {
        if (this.zone.cloud().name() == CloudName.AZURE) {
            return new NodeResources(2.0, this.tuning.logserverMem(4.0), 50.0, 0.3);
        }
        if (this.zone.cloud().name() == CloudName.GCP) {
            return new NodeResources(1.0, this.tuning.logserverMem(4.0), 50.0, 0.3);
        }
        return architecture == NodeResources.Architecture.arm64 ? new NodeResources(0.5, this.tuning.logserverMem(2.5), 50.0, 0.3) : new NodeResources(0.5, this.tuning.logserverMem(2.0), 50.0, 0.3);
    }

    private NodeResources smallestExclusiveResources() {
        if (this.zone.system().isKubernetes()) {
            return MIN_KUBERNETES_RESOURCES;
        }
        return this.zone.cloud().name() == CloudName.AZURE || this.zone.cloud().name() == CloudName.GCP ? new NodeResources(2.0, 8.0, 50.0, 0.3) : new NodeResources(0.5, 8.0, 50.0, 0.3);
    }

    private NodeResources smallestSharedResources() {
        if (this.zone.system().isKubernetes()) {
            throw new IllegalStateException("Not expecting shared nodes in Kubernetes");
        }
        return this.zone.cloud().name() == CloudName.GCP ? new NodeResources(1.0, 4.0, 50.0, 0.3) : new NodeResources(0.5, 2.0, 50.0, 0.3);
    }

    public ClusterSpec decideExclusivity(Capacity capacity, ClusterSpec requestedCluster) {
        if (capacity.cloudAccount().isPresent()) {
            return requestedCluster.withExclusivity(true);
        }
        boolean exclusive = requestedCluster.isExclusive() && (capacity.isRequired() || this.zone.environment() == Environment.prod);
        return requestedCluster.withExclusivity(exclusive);
    }

    private static NodeResources versioned(ClusterSpec spec, Map<Version, NodeResources> resources) {
        return Objects.requireNonNull(new TreeMap<Version, NodeResources>(resources).floorEntry(spec.vespaVersion()), "no default resources applicable for " + String.valueOf(spec) + " among: " + String.valueOf(resources)).getValue();
    }

    public record Tuning(NodeResources.Architecture adminClusterArchitecture, double logserverMemoryGiB, double clusterControllerMemoryGiB, long contentNodes) {
        public Tuning(NodeResources.Architecture adminClusterArchitecture, double logserverMemoryGiB, long contentNodes) {
            this(adminClusterArchitecture, logserverMemoryGiB, 0.0, contentNodes);
        }

        public Tuning(NodeResources.Architecture adminClusterArchitecture, double logserverMemoryGiB, double clusterControllerMemoryGiB) {
            this(adminClusterArchitecture, logserverMemoryGiB, clusterControllerMemoryGiB, 0L);
        }

        double logserverMem(double v) {
            double override = this.logserverMemoryGiB();
            return override > 0.0 ? override : v;
        }

        double clusterControllerMem(double v) {
            double override = this.clusterControllerMemoryGiB();
            return override > 0.0 ? override : v;
        }
    }
}

