/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.component.annotation.Inject;
import com.yahoo.config.provision.Flavor;
import com.yahoo.config.provision.NodeResources;
import com.yahoo.config.provisioning.FlavorsConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class NodeFlavors {
    private final Map<String, Flavor> configuredFlavors;

    @Inject
    public NodeFlavors(FlavorsConfig config) {
        this(NodeFlavors.toFlavors(config));
    }

    public NodeFlavors(Collection<Flavor> flavors) {
        LinkedHashMap<String, Flavor> map = new LinkedHashMap<String, Flavor>();
        for (Flavor flavor : flavors) {
            map.put(flavor.name(), flavor);
        }
        this.configuredFlavors = Collections.unmodifiableMap(map);
    }

    public List<Flavor> getFlavors() {
        return new ArrayList<Flavor>(this.configuredFlavors.values());
    }

    public Optional<Flavor> getFlavor(String name) {
        if (this.configuredFlavors.containsKey(name)) {
            return Optional.of(this.configuredFlavors.get(name));
        }
        NodeResources nodeResources = NodeResources.fromLegacyName(name);
        return Optional.of(new Flavor(nodeResources));
    }

    public Flavor getFlavorOrThrow(String flavorName) {
        return this.getFlavor(flavorName).orElseThrow(() -> new IllegalArgumentException("Unknown flavor '" + flavorName + "'"));
    }

    public boolean exists(String flavorName) {
        return this.getFlavor(flavorName).isPresent();
    }

    private static Collection<Flavor> toFlavors(FlavorsConfig config) {
        return config.flavor().stream().map(Flavor::new).toList();
    }

    public String toString() {
        return String.join((CharSequence)",", this.configuredFlavors.keySet());
    }
}

