/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.config.provision;

import com.yahoo.config.provision.CloudName;
import com.yahoo.config.provision.Zone;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CloudAccount
implements Comparable<CloudAccount> {
    private static final Map<String, CloudMeta> META_BY_CLOUD = Map.of("aws", new CloudMeta("Account ID", Pattern.compile("[0-9]{12}")), "azure", new CloudMeta("Subscription ID", Pattern.compile("[0-9a-f]{8}-([0-9a-f]{4}-){3}[0-9a-f]{12}")), "gcp", new CloudMeta("Project ID", Pattern.compile("[a-z][a-z0-9-]{4,28}[a-z0-9]")), "yahoo", new CloudMeta("OpenStack Project", Pattern.compile("[a-zA-Z0-9._-]+")));
    public static final CloudAccount empty = new CloudAccount("", CloudName.DEFAULT);
    private final String account;
    private final CloudName cloudName;

    private CloudAccount(String account, CloudName cloudName) {
        this.account = account;
        this.cloudName = cloudName;
    }

    public String account() {
        return this.account;
    }

    public CloudName cloudName() {
        return this.cloudName;
    }

    public final String value() {
        if (this.isUnspecified()) {
            return this.account;
        }
        return this.cloudName.value() + ":" + this.account;
    }

    public boolean isUnspecified() {
        return this.equals(empty);
    }

    public boolean isExclave(Zone zone) {
        return !this.isUnspecified() && zone.system().isPublic() && !this.equals(zone.cloud().account());
    }

    public boolean isEnclave(Zone zone) {
        return !this.isUnspecified() && !this.equals(zone.cloud().account());
    }

    public String toString() {
        return this.isUnspecified() ? "unspecified account" : "account '" + this.account + "' in " + String.valueOf((Object)this.cloudName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudAccount that = (CloudAccount)o;
        return this.account.equals(that.account) && this.cloudName.equals((Object)that.cloudName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.account, this.cloudName});
    }

    @Override
    public int compareTo(CloudAccount o) {
        return this.value().compareTo(o.value());
    }

    public static CloudAccount from(String cloudAccount) {
        int index = cloudAccount.indexOf(58);
        if (index < 0) {
            if (cloudAccount.isEmpty() || cloudAccount.equals("default")) {
                return empty;
            }
            if (META_BY_CLOUD.get("aws").matches(cloudAccount)) {
                return new CloudAccount(cloudAccount, CloudName.AWS);
            }
            if (META_BY_CLOUD.get("gcp").matches(cloudAccount)) {
                return new CloudAccount(cloudAccount, CloudName.GCP);
            }
            throw CloudAccount.illegal(cloudAccount, "Must be on format '<cloud-name>:<account>' or 'default'");
        }
        String cloud = cloudAccount.substring(0, index);
        String account = cloudAccount.substring(index + 1);
        CloudMeta cloudMeta = META_BY_CLOUD.get(cloud);
        if (cloudMeta == null) {
            throw CloudAccount.illegal(cloudAccount, "Cloud name must be one of: " + META_BY_CLOUD.keySet().stream().sorted().collect(Collectors.joining(", ")));
        }
        if (!cloudMeta.matches(account)) {
            throw CloudAccount.illegal(cloudAccount, cloudMeta.accountType + " must match '" + cloudMeta.pattern.pattern() + "'");
        }
        return new CloudAccount(account, CloudName.from(cloud));
    }

    private static IllegalArgumentException illegal(String cloudAccount, String details) {
        return new IllegalArgumentException("Invalid cloud account '" + cloudAccount + "': " + details);
    }

    private record CloudMeta(String accountType, Pattern pattern) {
        private boolean matches(String account) {
            return this.pattern.matcher(account).matches();
        }
    }
}

