/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.content;

import com.google.common.base.Preconditions;

public class SearchCoverage {
    private final Double minimum;
    private final Double minWaitAfterCoverageFactor;
    private final Double maxWaitAfterCoverageFactor;

    private SearchCoverage(Builder builder) {
        this.minimum = builder.minimum;
        this.minWaitAfterCoverageFactor = builder.minWaitAfterCoverageFactor;
        this.maxWaitAfterCoverageFactor = builder.maxWaitAfterCoverageFactor;
    }

    public Double getMinimum() {
        return this.minimum;
    }

    public Double getMinWaitAfterCoverageFactor() {
        return this.minWaitAfterCoverageFactor;
    }

    public Double getMaxWaitAfterCoverageFactor() {
        return this.maxWaitAfterCoverageFactor;
    }

    public static class Builder {
        private Double minimum;
        private Double minWaitAfterCoverageFactor;
        private Double maxWaitAfterCoverageFactor;

        public SearchCoverage build() {
            return new SearchCoverage(this);
        }

        public Builder setMinimum(Double value) {
            Preconditions.checkArgument((value == null || value >= 0.0 && value <= 1.0 ? 1 : 0) != 0, (Object)("Expected value in range [0, 1], got " + value + "."));
            this.minimum = value;
            return this;
        }

        public Builder setMinWaitAfterCoverageFactor(Double value) {
            Preconditions.checkArgument((value == null || value >= 0.0 && value <= 1.0 ? 1 : 0) != 0, (Object)("Expected value in range [0, 1], got " + value + "."));
            Preconditions.checkArgument((value == null || this.maxWaitAfterCoverageFactor == null || value <= this.maxWaitAfterCoverageFactor ? 1 : 0) != 0, (String)"Minimum wait (got %s) must be no larger than maximum wait (was %s).", (Object)value, (Object)this.maxWaitAfterCoverageFactor);
            this.minWaitAfterCoverageFactor = value;
            return this;
        }

        public Builder setMaxWaitAfterCoverageFactor(Double value) {
            Preconditions.checkArgument((value == null || value >= 0.0 && value <= 1.0 ? 1 : 0) != 0, (Object)("Expected value in range [0, 1], got " + value + "."));
            Preconditions.checkArgument((value == null || this.minWaitAfterCoverageFactor == null || value >= this.minWaitAfterCoverageFactor ? 1 : 0) != 0, (String)"Maximum wait (got %s) must be no smaller than minimum wait (was %s).", (Object)value, (Object)this.minWaitAfterCoverageFactor);
            this.maxWaitAfterCoverageFactor = value;
            return this;
        }
    }
}

