/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.builder.xml.dom;

import com.yahoo.text.XML;
import com.yahoo.vespa.model.builder.xml.dom.BinaryUnit;
import com.yahoo.vespa.model.utils.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class ModelElement {
    private final Element xml;

    public ModelElement(Element xml) {
        this.xml = Objects.requireNonNull(xml, "Can not create ModelElement with null element");
    }

    public Element getXml() {
        return this.xml;
    }

    public ModelElement child(String name) {
        Element e = XML.getChild((Element)this.xml, (String)name);
        if (e == null) {
            return null;
        }
        return new ModelElement(e);
    }

    public List<ModelElement> children(String name) {
        List e = XML.getChildren((Element)this.xml, (String)name);
        ArrayList<ModelElement> list = new ArrayList<ModelElement>();
        e.forEach(element -> list.add(new ModelElement((Element)element)));
        return list;
    }

    public ModelElement childByPath(String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, ".");
        ModelElement curElem = this;
        while (tokenizer.hasMoreTokens() && curElem != null) {
            String pathElem = tokenizer.nextToken();
            ModelElement child = curElem.child(pathElem);
            if (!tokenizer.hasMoreTokens() && child != null) {
                return child;
            }
            curElem = child;
        }
        return null;
    }

    public String childAsString(String path) {
        StringTokenizer tokenizer = new StringTokenizer(path, ".");
        ModelElement curElem = this;
        while (tokenizer.hasMoreTokens() && curElem != null) {
            String pathElem = tokenizer.nextToken();
            ModelElement child = curElem.child(pathElem);
            if (!tokenizer.hasMoreTokens()) {
                String attr = curElem.stringAttribute(pathElem);
                if (attr != null) {
                    return attr;
                }
                if (child != null) {
                    return child.asString();
                }
            }
            curElem = child;
        }
        return null;
    }

    public String asString() {
        return this.xml.getFirstChild().getTextContent();
    }

    public double asDouble() {
        return Double.parseDouble(this.asString());
    }

    public long asLong() {
        return (long)BinaryUnit.valueOf(this.asString());
    }

    public Duration asDuration() {
        return new Duration(this.asString());
    }

    public Long childAsLong(String path) {
        String child = this.childAsString(path);
        if (child == null) {
            return null;
        }
        return Long.parseLong(child.trim());
    }

    public Integer childAsInteger(String path) {
        String child = this.childAsString(path);
        if (child == null) {
            return null;
        }
        return Integer.parseInt(child.trim());
    }

    public Double childAsDouble(String path) {
        String child = this.childAsString(path);
        if (child == null) {
            return null;
        }
        return Double.parseDouble(child.trim());
    }

    public Boolean childAsBoolean(String path) {
        String child = this.childAsString(path);
        if (child == null) {
            return null;
        }
        return Boolean.parseBoolean(child.trim());
    }

    public Duration childAsDuration(String path) {
        String child = this.childAsString(path);
        if (child == null) {
            return null;
        }
        return new Duration(child);
    }

    public int requiredIntegerAttribute(String name) {
        if (this.stringAttribute(name) == null) {
            throw new IllegalArgumentException("Required attribute '" + name + "' is missing");
        }
        return this.integerAttribute(name, null);
    }

    public Integer integerAttribute(String name) {
        return this.integerAttribute(name, null);
    }

    public Integer integerAttribute(String name, Integer defaultValue) {
        String value = this.stringAttribute(name);
        if (value == null) {
            return defaultValue;
        }
        return (int)BinaryUnit.valueOf(value);
    }

    public boolean booleanAttribute(String name) {
        return this.booleanAttribute(name, false);
    }

    public boolean booleanAttribute(String name, boolean defaultValue) {
        String value = this.stringAttribute(name);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public Long longAttribute(String name) {
        String value = this.stringAttribute(name);
        if (value == null) {
            return null;
        }
        return (long)BinaryUnit.valueOf(value);
    }

    public Double doubleAttribute(String name) {
        String value = this.stringAttribute(name);
        if (value == null) {
            return null;
        }
        return Double.parseDouble(value);
    }

    public double requiredDoubleAttribute(String name) {
        if (this.stringAttribute(name) == null) {
            throw new IllegalArgumentException("Required attribute '" + name + "' is missing");
        }
        return this.doubleAttribute(name);
    }

    public String stringAttribute(String name) {
        return this.stringAttribute(name, null);
    }

    public String stringAttribute(String name, String defaultValue) {
        if (!this.xml.hasAttribute(name)) {
            return defaultValue;
        }
        return this.xml.getAttribute(name);
    }

    public String requiredStringAttribute(String name) {
        if (this.stringAttribute(name) == null) {
            throw new IllegalArgumentException("Required attribute '" + name + "' is missing");
        }
        return this.stringAttribute(name);
    }

    public List<ModelElement> subElements(String name) {
        List elements = XML.getChildren((Element)this.xml, (String)name);
        ArrayList<ModelElement> helpers = new ArrayList<ModelElement>();
        for (Element e : elements) {
            helpers.add(new ModelElement(e));
        }
        return helpers;
    }

    public String toString() {
        return this.xml.getNodeName();
    }
}

