/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation;

import com.yahoo.config.model.api.TenantVault;
import com.yahoo.vespa.model.application.validation.Validation;
import com.yahoo.vespa.model.application.validation.Validator;
import com.yahoo.vespa.model.container.ApplicationContainerCluster;
import com.yahoo.vespa.model.container.xml.CloudSecrets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class TenantSecretValidator
implements Validator {
    @Override
    public void validate(Validation.Context context) {
        if (!context.deployState().isHosted()) {
            return;
        }
        if (!context.deployState().zone().system().isPublicCloudLike()) {
            return;
        }
        for (ApplicationContainerCluster cluster : context.model().getContainerClusters().values()) {
            Map<String, List> existingVaults = context.deployState().getProperties().tenantVaults().stream().collect(Collectors.toMap(TenantVault::name, TenantVault::secrets));
            Optional<CloudSecrets> cloudSecrets = cluster.getTenantSecrets();
            if (!cloudSecrets.isPresent()) continue;
            CloudSecrets secrets = cloudSecrets.get();
            for (CloudSecrets.SecretConfig secretConfig : secrets.configuredSecrets()) {
                if (!existingVaults.containsKey(secretConfig.vault())) {
                    context.illegal("Vault '" + secretConfig.vault() + "' does not exist, or application does not have access to it");
                    continue;
                }
                List vaultSecrets = existingVaults.get(secretConfig.vault());
                if (this.hasSecret(secretConfig.name(), vaultSecrets)) continue;
                context.illegal("Secret '%s' is not defined in vault '%s'".formatted(secretConfig.name(), secretConfig.vault()));
            }
        }
    }

    private boolean hasSecret(String secretName, List<TenantVault.Secret> secrets) {
        return secrets.stream().anyMatch(secret -> secret.name().equals(secretName));
    }
}

