/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.schema.derived;

import com.yahoo.config.application.api.FileRegistry;
import com.yahoo.schema.DistributableResource;
import com.yahoo.schema.RankProfile;
import com.yahoo.tensor.TensorType;
import com.yahoo.vespa.config.search.core.RankingConstantsConfig;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class FileDistributedConstants {
    private final Map<String, DistributableConstant> constants;

    public FileDistributedConstants(FileRegistry fileRegistry, Collection<RankProfile.Constant> constants) {
        LinkedHashMap<String, DistributableConstant> distributableConstants = new LinkedHashMap<String, DistributableConstant>();
        for (RankProfile.Constant constant : constants) {
            if (constant.valuePath().isEmpty()) continue;
            DistributableConstant distributableConstant = new DistributableConstant((String)constant.name().simpleArgument().get(), constant.type(), constant.valuePath().get(), constant.pathType().get());
            distributableConstant.validate();
            distributableConstant.register(fileRegistry);
            distributableConstants.put(distributableConstant.getName(), distributableConstant);
        }
        this.constants = Collections.unmodifiableMap(distributableConstants);
    }

    public Map<String, DistributableConstant> asMap() {
        return this.constants;
    }

    private static RankingConstantsConfig.Constant.Builder toConfig(DistributableConstant constant) {
        return new RankingConstantsConfig.Constant.Builder().name(constant.getName()).fileref(constant.getFileReference()).type(constant.getType());
    }

    public List<RankingConstantsConfig.Constant.Builder> getConfig() {
        return this.constants.values().stream().map(FileDistributedConstants::toConfig).toList();
    }

    public static class DistributableConstant
    extends DistributableResource {
        private final TensorType tensorType;

        public DistributableConstant(String name, TensorType type, String fileName, DistributableResource.PathType pathType) {
            super(name, fileName, pathType);
            this.tensorType = type;
            this.validate();
        }

        public TensorType getTensorType() {
            return this.tensorType;
        }

        public String getType() {
            return this.tensorType.toString();
        }

        @Override
        public void validate() {
            super.validate();
            if (this.tensorType == null) {
                throw new IllegalArgumentException("Ranking constant '" + this.getName() + "' must have a type.");
            }
            if (this.tensorType.dimensions().stream().anyMatch(d -> d.isIndexed() && d.size().isEmpty())) {
                throw new IllegalArgumentException("Illegal type in field " + this.getName() + " type " + String.valueOf(this.tensorType) + ": Dense tensor dimensions must have a size");
            }
        }

        @Override
        public String toString() {
            return super.toString() + "' of type '" + String.valueOf(this.tensorType) + "'";
        }
    }
}

