/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.vespa.model.application.validation.change.search;

import com.yahoo.config.application.api.ValidationId;
import com.yahoo.config.model.deploy.DeployState;
import com.yahoo.config.provision.ClusterSpec;
import com.yahoo.documentmodel.NewDocumentType;
import com.yahoo.schema.derived.AttributeFields;
import com.yahoo.schema.derived.IndexSchema;
import com.yahoo.schema.document.Attribute;
import com.yahoo.schema.document.Case;
import com.yahoo.schema.document.Dictionary;
import com.yahoo.schema.document.HnswIndexParams;
import com.yahoo.vespa.model.application.validation.change.VespaConfigChangeAction;
import com.yahoo.vespa.model.application.validation.change.VespaRestartAction;
import com.yahoo.vespa.model.application.validation.change.search.ChangeMessageBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class AttributeChangeValidator {
    private final ClusterSpec.Id id;
    private final AttributeFields currentFields;
    private final IndexSchema currentIndexSchema;
    private final NewDocumentType currentDocType;
    private final AttributeFields nextFields;
    private final IndexSchema nextIndexSchema;
    private final NewDocumentType nextDocType;
    private final DeployState deployState;

    public AttributeChangeValidator(ClusterSpec.Id id, AttributeFields currentFields, IndexSchema currentIndexSchema, NewDocumentType currentDocType, AttributeFields nextFields, IndexSchema nextIndexSchema, NewDocumentType nextDocType, DeployState deployState) {
        this.id = id;
        this.currentFields = currentFields;
        this.currentIndexSchema = currentIndexSchema;
        this.currentDocType = currentDocType;
        this.nextFields = nextFields;
        this.nextIndexSchema = nextIndexSchema;
        this.nextDocType = nextDocType;
        this.deployState = deployState;
    }

    public List<VespaConfigChangeAction> validate() {
        ArrayList<VespaConfigChangeAction> result = new ArrayList<VespaConfigChangeAction>();
        result.addAll(this.validateAddAttributeAspect());
        result.addAll(this.validateRemoveAttributeAspect());
        result.addAll(this.validateAttributeSettings());
        return result;
    }

    private List<VespaConfigChangeAction> validateAddAttributeAspect() {
        return this.nextFields.attributes().stream().map(Attribute::getName).filter(attrName -> !this.currentFields.containsAttribute((String)attrName) && this.currentDocType.containsField((String)attrName)).map(attrName -> new VespaRestartAction(this.id, new ChangeMessageBuilder((String)attrName).addChange("add attribute aspect").build())).collect(Collectors.toList());
    }

    private List<VespaConfigChangeAction> validateRemoveAttributeAspect() {
        return this.currentFields.attributes().stream().map(Attribute::getName).filter(attrName -> !this.nextFields.containsAttribute((String)attrName) && this.nextDocType.containsField((String)attrName) && !this.isIndexField((String)attrName)).map(attrName -> new VespaRestartAction(this.id, new ChangeMessageBuilder((String)attrName).addChange("remove attribute aspect").build())).collect(Collectors.toList());
    }

    private boolean isIndexField(String fieldName) {
        return this.currentIndexSchema.containsField(fieldName) && this.nextIndexSchema.containsField(fieldName);
    }

    private static boolean hasHnswIndex(Attribute attribute) {
        return attribute.hnswIndexParams().isPresent();
    }

    private static Dictionary.Type extractDictionaryType(Attribute attr) {
        Dictionary dict = attr.getDictionary();
        return dict != null ? dict.getType() : Dictionary.Type.BTREE;
    }

    private static Case extractDictionaryCase(Attribute attr) {
        Dictionary dict = attr.getDictionary();
        return dict != null ? dict.getMatch() : Case.UNCASED;
    }

    private List<VespaConfigChangeAction> validateAttributeSettings() {
        ArrayList<VespaConfigChangeAction> result = new ArrayList<VespaConfigChangeAction>();
        for (Attribute next : this.nextFields.attributes()) {
            Attribute current = this.currentFields.getAttribute(next.getName());
            if (current == null) continue;
            AttributeChangeValidator.validateAttributePredicate(this.id, current, next, Attribute::isFastSearch, "fast-search", result);
            AttributeChangeValidator.validateAttributePredicate(this.id, current, next, Attribute::isFastRank, "fast-rank", result);
            AttributeChangeValidator.validateAttributePredicate(this.id, current, next, Attribute::isFastAccess, "fast-access", result);
            this.validateAttributeProperty(this.id, current, next, AttributeChangeValidator::extractDictionaryType, "dictionary: btree/hash", result);
            this.validateAttributeProperty(this.id, current, next, AttributeChangeValidator::extractDictionaryCase, "dictionary: cased/uncased", result);
            AttributeChangeValidator.validateAttributePredicate(this.id, current, next, Attribute::isPaged, "paged", result);
            this.validatePagedAttributeRemoval(current, next);
            this.validateAttributeProperty(this.id, current, next, Attribute::densePostingListThreshold, "dense-posting-list-threshold", result);
            AttributeChangeValidator.validateAttributePredicate(this.id, current, next, Attribute::isEnabledOnlyBitVector, "rank: filter", result);
            this.validateAttributeProperty(this.id, current, next, Attribute::distanceMetric, "distance-metric", result);
            AttributeChangeValidator.validateAttributePredicate(this.id, current, next, AttributeChangeValidator::hasHnswIndex, "indexing: index", result);
            if (!AttributeChangeValidator.hasHnswIndex(current) || !AttributeChangeValidator.hasHnswIndex(next)) continue;
            this.validateAttributeHnswIndexSetting(this.id, current, next, HnswIndexParams::maxLinksPerNode, "max-links-per-node", result);
            this.validateAttributeHnswIndexSetting(this.id, current, next, HnswIndexParams::neighborsToExploreAtInsert, "neighbors-to-explore-at-insert", result);
        }
        return result;
    }

    private static void validateAttributePredicate(ClusterSpec.Id id, Attribute currentAttr, Attribute nextAttr, Predicate<Attribute> predicate, String setting, List<VespaConfigChangeAction> result) {
        boolean nextValue = predicate.test(nextAttr);
        if (predicate.test(currentAttr) != nextValue) {
            String change = nextValue ? "add" : "remove";
            result.add(new VespaRestartAction(id, new ChangeMessageBuilder(nextAttr.getName()).addChange(change + " attribute '" + setting + "'").build()));
        }
    }

    private <T> void validateAttributeProperty(ClusterSpec.Id id, Attribute current, Attribute next, Function<Attribute, T> settingValueProvider, String setting, List<VespaConfigChangeAction> result) {
        T nextValue;
        T currentValue = settingValueProvider.apply(current);
        if (!Objects.equals(currentValue, nextValue = settingValueProvider.apply(next))) {
            String message = String.format("change property '%s' from '%s' to '%s'", setting, currentValue, nextValue);
            if (AttributeChangeValidator.hasHnswIndex(current) && AttributeChangeValidator.hasHnswIndex(next)) {
                this.deployState.validationOverrides().invalid(ValidationId.hnswSettingsChange, message + ". This requires the hnsw index to be rebuilt during initialization, which may take a long time", this.deployState.now());
            }
            result.add(new VespaRestartAction(id, new ChangeMessageBuilder(next.getName()).addChange(message).build()));
        }
    }

    private <T> void validateAttributeHnswIndexSetting(ClusterSpec.Id id, Attribute currentAttr, Attribute nextAttr, Function<HnswIndexParams, T> settingValueProvider, String setting, List<VespaConfigChangeAction> result) {
        T nextValue;
        T currentValue = settingValueProvider.apply(currentAttr.hnswIndexParams().get());
        if (!Objects.equals(currentValue, nextValue = settingValueProvider.apply(nextAttr.hnswIndexParams().get()))) {
            String message = String.format("change hnsw index property '%s' from '%s' to '%s'", setting, currentValue, nextValue);
            if (setting.equals("max-links-per-node")) {
                this.deployState.validationOverrides().invalid(ValidationId.hnswSettingsChange, message + ". This requires the hnsw index to be rebuilt during initialization, which may take a long time", this.deployState.now());
            }
            result.add(new VespaRestartAction(id, new ChangeMessageBuilder(nextAttr.getName()).addChange(message).build()));
        }
    }

    private void validatePagedAttributeRemoval(Attribute current, Attribute next) {
        if (current.isPaged() && !next.isPaged()) {
            this.deployState.validationOverrides().invalid(ValidationId.pagedSettingRemoval, String.valueOf(current) + "' has setting 'paged' removed. This may cause content nodes to run out of memory as the entire attribute is loaded into memory", this.deployState.now());
        }
    }
}

